/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.sign;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import net.sf.mmm.crypto.algorithm.AbstractCryptoAlgorithmWithRandom;
import net.sf.mmm.crypto.algorithm.AbstractSecurityAlgorithm;
import net.sf.mmm.crypto.asymmetric.sign.SignatureBinary;
import net.sf.mmm.crypto.asymmetric.sign.SignatureConfig;
import net.sf.mmm.crypto.asymmetric.sign.SignatureProcessorFactory;
import net.sf.mmm.crypto.asymmetric.sign.SignatureSigner;
import net.sf.mmm.crypto.asymmetric.sign.SignatureSignerImpl;
import net.sf.mmm.crypto.asymmetric.sign.SignatureSignerImplWithHash;
import net.sf.mmm.crypto.asymmetric.sign.SignatureVerifier;
import net.sf.mmm.crypto.asymmetric.sign.SignatureVerifierImpl;
import net.sf.mmm.crypto.asymmetric.sign.SignatureVerifierImplWithHash;
import net.sf.mmm.crypto.hash.HashConfig;
import net.sf.mmm.crypto.hash.HashCreator;
import net.sf.mmm.crypto.hash.HashCreatorImplDigest;
import net.sf.mmm.crypto.hash.HashCreatorImplMultipleRounds;
import net.sf.mmm.crypto.random.RandomFactory;

public class SignatureProcessorFactoryImpl<S extends SignatureBinary, PR extends PrivateKey, PU extends PublicKey>
extends AbstractCryptoAlgorithmWithRandom
implements SignatureProcessorFactory<S, PR, PU> {
    private final SignatureConfig<S> config;

    public SignatureProcessorFactoryImpl(SignatureConfig<S> config, RandomFactory randomFactory) {
        super(config.getProvider(), randomFactory);
        this.config = config;
    }

    @Override
    public String getAlgorithm() {
        return this.config.getAlgorithm();
    }

    private HashCreator newHashCreator() {
        HashConfig hashConfig = this.config.getHashConfig();
        if (hashConfig != null) {
            String algorithm = hashConfig.getAlgorithm();
            if ("NONE".equals(algorithm)) {
                return null;
            }
            int iterationCount = hashConfig.getIterationCount();
            if (iterationCount == 1) {
                return new HashCreatorImplDigest(algorithm, this.getProvider());
            }
            assert (iterationCount > 1);
            return new HashCreatorImplMultipleRounds(algorithm, this.getProvider(), iterationCount);
        }
        return null;
    }

    @Override
    public SignatureSigner<S> newSigner(PR privateKey) {
        try {
            Signature signature = this.getProvider().createSignature(this.config.getAlgorithm());
            signature.initSign((PrivateKey)privateKey, this.createSecureRandom());
            AbstractSecurityAlgorithm signer = new SignatureSignerImpl<S>(signature, this.config.getSignatureFactory());
            HashCreator hashGenerator = this.newHashCreator();
            if (hashGenerator != null) {
                signer = new SignatureSignerImplWithHash<S>(hashGenerator, signer);
            }
            return signer;
        }
        catch (Exception e) {
            throw this.creationFailedException(e, Signature.class);
        }
    }

    @Override
    public SignatureVerifier<S> newVerifier(PU publicKey) {
        try {
            Signature signature = this.getProvider().createSignature(this.config.getAlgorithm());
            signature.initVerify((PublicKey)publicKey);
            AbstractSecurityAlgorithm verifier = new SignatureVerifierImpl(signature);
            HashCreator hashGenerator = this.newHashCreator();
            if (hashGenerator != null) {
                verifier = new SignatureVerifierImplWithHash(hashGenerator, verifier);
            }
            return verifier;
        }
        catch (Exception e) {
            throw this.creationFailedException(e, Signature.class);
        }
    }

    @Override
    public S createSignature(byte[] data) {
        return this.config.getSignatureFactory().createSignature(data);
    }

    @Override
    public SignatureProcessorFactory<S, PR, PU> getSignatureFactoryWithoutHash() {
        if (this.config.getHashConfig() == null) {
            return this;
        }
        return new SignatureProcessorFactoryImpl<S, PR, PU>(this.config.withoutHashConfig(), this.getRandomFactory());
    }
}

