/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.sign;

import net.sf.mmm.crypto.algorithm.CryptoAlgorithmConfig;
import net.sf.mmm.crypto.asymmetric.sign.SignatureAlgorithm;
import net.sf.mmm.crypto.asymmetric.sign.SignatureBinary;
import net.sf.mmm.crypto.asymmetric.sign.SignatureFactory;
import net.sf.mmm.crypto.hash.HashConfig;
import net.sf.mmm.crypto.provider.SecurityProvider;

public class SignatureConfig<S extends SignatureBinary>
extends CryptoAlgorithmConfig {
    private final HashConfig hashConfig;
    private final SignatureFactory<S> signatureFactory;
    private final SignatureAlgorithm signatureAlgorithm;

    public SignatureConfig(SignatureFactory<S> signatureFactory, HashConfig hashConfig, String signingAlgorithm, String hashAlgorithm, SecurityProvider provider) {
        this(signatureFactory, SignatureAlgorithm.of(hashAlgorithm, signingAlgorithm), hashConfig, provider);
    }

    public SignatureConfig(SignatureFactory<S> signatureFactory, HashConfig hashConfig, String signingAlgorithm, SecurityProvider provider) {
        this(signatureFactory, SignatureAlgorithm.of(hashConfig.getAlgorithm(), signingAlgorithm), hashConfig, provider);
    }

    private SignatureConfig(SignatureFactory<S> signatureFactory, SignatureAlgorithm signatureAlgorithm, HashConfig hashConfig, SecurityProvider provider) {
        super(signatureAlgorithm.getAlgorithm(), provider);
        this.signatureFactory = signatureFactory;
        this.hashConfig = hashConfig;
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public HashConfig getHashConfig() {
        return this.hashConfig;
    }

    public SignatureFactory<S> getSignatureFactory() {
        return this.signatureFactory;
    }

    public SignatureConfig<S> withoutHashConfig() {
        if (this.hashConfig == null) {
            return this;
        }
        return new SignatureConfig<S>(this.signatureFactory, this.signatureAlgorithm, null, this.provider);
    }
}

