/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.sign;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.sf.mmm.crypto.algorithm.CryptoAlgorithm;

public final class SignatureAlgorithm
implements CryptoAlgorithm {
    private static final String SEPARATOR = "with";
    private static final Map<String, String> DIGEST2SIGNATURE_MAP = new HashMap<String, String>();
    private static final Map<String, String> SIGNATURE2DIGEST_MAP = new HashMap<String, String>();
    private final String hashAlgorithm;
    private final String signingAlgorithm;
    private final String algorithm;

    private SignatureAlgorithm(String hashAlgorithm, String signingAlgorithm, String algorithm) {
        this.hashAlgorithm = hashAlgorithm;
        this.signingAlgorithm = signingAlgorithm;
        this.algorithm = algorithm;
    }

    private static void register(String digest) {
        SignatureAlgorithm.register(digest, digest.replace("SHA-", "SHA"));
    }

    private static void register(String digest, String signaturePrefix) {
        DIGEST2SIGNATURE_MAP.put(digest, signaturePrefix);
        SIGNATURE2DIGEST_MAP.put(signaturePrefix, digest);
    }

    private static String require(String value, String name) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Value for " + name + " is required and must not be '" + value + "'!");
        }
        return value;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public boolean isNoHashing() {
        return "NONE".equals(this.hashAlgorithm);
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public int hashCode() {
        return this.algorithm.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SignatureAlgorithm other = (SignatureAlgorithm)obj;
        return Objects.equals(this.algorithm, other.algorithm);
    }

    public String toString() {
        return this.algorithm;
    }

    public static SignatureAlgorithm of(String hashAlgorithm, String signingAlgorithm) {
        SignatureAlgorithm.register(signingAlgorithm, "signingAlgorithm");
        String algorithm = hashAlgorithm == null ? signingAlgorithm : SignatureAlgorithm.hash2sign(hashAlgorithm) + SEPARATOR + signingAlgorithm;
        return new SignatureAlgorithm(hashAlgorithm, signingAlgorithm, algorithm);
    }

    private static String hash2sign(String hashingAlgorithm) {
        String signaturePrefix = DIGEST2SIGNATURE_MAP.get(hashingAlgorithm);
        if (signaturePrefix != null) {
            return signaturePrefix;
        }
        return hashingAlgorithm;
    }

    public static SignatureAlgorithm of(String algorithm) {
        String signatureAlgorithm;
        String signingAlgorithm;
        String hashAlgorithm;
        SignatureAlgorithm.require(algorithm, "algorithm");
        int separatorStartIndex = algorithm.indexOf(SEPARATOR);
        if (separatorStartIndex < 0) {
            hashAlgorithm = null;
            signingAlgorithm = algorithm;
            signatureAlgorithm = algorithm;
        } else {
            assert (separatorStartIndex > 0);
            hashAlgorithm = SignatureAlgorithm.sign2hash(algorithm.substring(0, separatorStartIndex));
            signingAlgorithm = algorithm.substring(separatorStartIndex + SEPARATOR.length());
            signatureAlgorithm = SignatureAlgorithm.hash2sign(hashAlgorithm) + SEPARATOR + signingAlgorithm;
        }
        return new SignatureAlgorithm(hashAlgorithm, signingAlgorithm, signatureAlgorithm);
    }

    private static String sign2hash(String signaturePrefix) {
        String hashing = SIGNATURE2DIGEST_MAP.get(signaturePrefix);
        if (hashing != null) {
            return hashing;
        }
        return signaturePrefix;
    }

    static {
        SignatureAlgorithm.register("SHA-224");
        SignatureAlgorithm.register("SHA-256");
        SignatureAlgorithm.register("SHA-384");
        SignatureAlgorithm.register("SHA-512");
        SignatureAlgorithm.register("SHA-512/224");
        SignatureAlgorithm.register("SHA-512/256");
    }
}

