/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.key.rsa;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import net.sf.mmm.crypto.asymmetric.key.AbstractAsymmetricKeyPair;

public class AsymmetricKeyPairRsa
extends AbstractAsymmetricKeyPair<RSAPrivateKey, RSAPublicKey> {
    public static final String ALGORITHM_RSA = "RSA";
    static BigInteger PUBLIC_EXPONENT = new BigInteger("65537");
    private static KeyFactory keyFactory;

    public AsymmetricKeyPairRsa(RSAPrivateKey privateKey, RSAPublicKey publicKey) {
        super(privateKey, publicKey);
    }

    public static AsymmetricKeyPairRsa of(BigInteger modulus, BigInteger privateExponent, BigInteger publicExponent) {
        RSAPrivateKey privateKey = AsymmetricKeyPairRsa.createPrivateKey(modulus, privateExponent);
        RSAPublicKey publicKey = AsymmetricKeyPairRsa.createPublicKey(modulus, publicExponent);
        return new AsymmetricKeyPairRsa(privateKey, publicKey);
    }

    public static RSAPublicKey createPublicKey(BigInteger modulus) {
        return AsymmetricKeyPairRsa.createPublicKey(modulus, PUBLIC_EXPONENT);
    }

    public static RSAPublicKey createPublicKey(BigInteger modulus, BigInteger publicExponent) {
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(modulus, publicExponent);
        return AsymmetricKeyPairRsa.createPublicKey(keySpec);
    }

    public static RSAPublicKey createPublicKey(RSAPublicKeySpec keySpec) {
        try {
            return (RSAPublicKey)AsymmetricKeyPairRsa.getKeyFactory().generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static AsymmetricKeyPairRsa of(BigInteger modulus, BigInteger privateExponent) {
        return AsymmetricKeyPairRsa.of(modulus, privateExponent, PUBLIC_EXPONENT);
    }

    public static AsymmetricKeyPairRsa of(String modulus, String privateExponent) {
        return AsymmetricKeyPairRsa.of(new BigInteger(modulus), new BigInteger(privateExponent), PUBLIC_EXPONENT);
    }

    public static RSAPrivateKey createPrivateKey(BigInteger modulus, BigInteger privateExponent) {
        RSAPrivateKeySpec keySpec = new RSAPrivateKeySpec(modulus, privateExponent);
        return AsymmetricKeyPairRsa.createPrivateKey(keySpec);
    }

    public static RSAPrivateKey createPrivateKey(RSAPrivateKeySpec keySpec) {
        try {
            return (RSAPrivateKey)AsymmetricKeyPairRsa.getKeyFactory().generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static KeyFactory getKeyFactory() {
        if (keyFactory == null) {
            try {
                keyFactory = KeyFactory.getInstance(ALGORITHM_RSA);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }
        return keyFactory;
    }
}

