/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.key.rsa;

import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Objects;
import net.sf.mmm.crypto.asymmetric.key.AbstractAsymmetricKeyCreator;
import net.sf.mmm.crypto.asymmetric.key.rsa.AsymmetricKeyPairFactoryRsaCompact;
import net.sf.mmm.crypto.asymmetric.key.rsa.AsymmetricKeyPairRsa;
import net.sf.mmm.crypto.provider.SecurityProvider;
import net.sf.mmm.crypto.random.RandomFactory;

public class AsymmetricKeyCreatorRsa
extends AbstractAsymmetricKeyCreator<RSAPrivateKey, RSAPublicKey, AsymmetricKeyPairRsa> {
    public AsymmetricKeyCreatorRsa(int keyLength) {
        this(keyLength, null, null);
    }

    public AsymmetricKeyCreatorRsa(int keyLength, SecurityProvider provider, RandomFactory randomFactory) {
        super(AsymmetricKeyPairRsa.getKeyFactory(), keyLength, provider, randomFactory);
        this.register(new AsymmetricKeyPairFactoryRsaCompact());
    }

    @Override
    public AsymmetricKeyPairRsa createKeyPair(RSAPrivateKey privateKey, RSAPublicKey publicKey) {
        return new AsymmetricKeyPairRsa(privateKey, publicKey);
    }

    @Override
    public int getKeyLength(RSAPrivateKey privateKey) {
        Objects.requireNonNull(privateKey, "privateKey");
        return privateKey.getModulus().bitLength();
    }

    @Override
    public int getKeyLength(RSAPublicKey publicKey) {
        Objects.requireNonNull(publicKey, "publicKey");
        return publicKey.getModulus().bitLength();
    }
}

