/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.key.generic;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import net.sf.mmm.crypto.asymmetric.key.AbstractAsymmetricKeyPair;
import net.sf.mmm.crypto.asymmetric.key.AbstractAsymmetricKeyPairFactory;
import net.sf.mmm.crypto.asymmetric.key.AsymmetricKeyPairFactorySimple;

public class AsymmetricKeyPairFactoryEncoded<PR extends PrivateKey, PU extends PublicKey, PAIR extends AbstractAsymmetricKeyPair<PR, PU>>
extends AbstractAsymmetricKeyPairFactory<PR, PU, PAIR> {
    private AsymmetricKeyPairFactorySimple<PR, PU, PAIR> keyPairCreator;

    public AsymmetricKeyPairFactoryEncoded(KeyFactory keyFactory, AsymmetricKeyPairFactorySimple<PR, PU, PAIR> keyPairCreator) {
        super(keyFactory);
        this.keyPairCreator = keyPairCreator;
    }

    @Override
    public byte[] asData(PR privateKey) {
        return privateKey.getEncoded();
    }

    @Override
    public PR createPrivateKey(byte[] data) {
        return this.createPrivateKey(new PKCS8EncodedKeySpec(data));
    }

    @Override
    public byte[] asData(PU publicKey) {
        return publicKey.getEncoded();
    }

    @Override
    public PU createPublicKey(byte[] data) {
        return this.createPublicKey(new X509EncodedKeySpec(data));
    }

    @Override
    public byte[] asData(PAIR keyPair) {
        byte[] privateData = this.asData((PAIR)((AbstractAsymmetricKeyPair)keyPair).getPrivateKey());
        byte[] publicData = this.asData((PAIR)((AbstractAsymmetricKeyPair)keyPair).getPublicKey());
        byte[] data = new byte[privateData.length + publicData.length];
        System.arraycopy(privateData, 0, data, 0, privateData.length);
        System.arraycopy(publicData, 0, data, privateData.length, publicData.length);
        return data;
    }

    @Override
    public PAIR createKeyPair(PR privateKey, PU publicKey) {
        return (PAIR)((AbstractAsymmetricKeyPair)this.keyPairCreator.createKeyPair(privateKey, publicKey));
    }

    @Override
    public PAIR createKeyPair(byte[] data) {
        int privateDataLength = data.length / 2;
        byte[] privateData = new byte[privateDataLength];
        byte[] publicData = new byte[data.length - privateDataLength];
        System.arraycopy(data, 0, privateData, 0, privateDataLength);
        System.arraycopy(data, privateDataLength, publicData, 0, publicData.length);
        PR privateKey = this.createPrivateKey(privateData);
        PU publicKey = this.createPublicKey(publicData);
        return (PAIR)this.createKeyPair((PrivateKey)privateKey, (PublicKey)publicKey);
    }
}

