/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.key.generic;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.sf.mmm.crypto.asymmetric.key.AbstractAsymmetricKeyCreator;
import net.sf.mmm.crypto.asymmetric.key.AbstractAsymmetricKeyPair;
import net.sf.mmm.crypto.asymmetric.key.AsymmetricKeyCreator;
import net.sf.mmm.crypto.asymmetric.key.AsymmetricKeyPairFactorySimple;
import net.sf.mmm.crypto.asymmetric.key.generic.AsymmetricKeyPairFactoryGeneric;
import net.sf.mmm.crypto.asymmetric.key.generic.AsymmetricKeyPairGeneric;
import net.sf.mmm.crypto.provider.SecurityProvider;
import net.sf.mmm.crypto.random.RandomFactory;

public class AsymmetricKeyCreatorImpl<PR extends PrivateKey, PU extends PublicKey, PAIR extends AbstractAsymmetricKeyPair<PR, PU>>
extends AbstractAsymmetricKeyCreator<PR, PU, PAIR> {
    private final AsymmetricKeyPairFactorySimple<PR, PU, PAIR> keyPairFactory;

    public AsymmetricKeyCreatorImpl(KeyFactory keyFactory, int keyLength, SecurityProvider provider, AsymmetricKeyPairFactorySimple<PR, PU, PAIR> keyPairFactory, RandomFactory randomFactory) {
        super(keyFactory, keyLength, provider, randomFactory);
        this.keyPairFactory = keyPairFactory;
    }

    @Override
    public PAIR createKeyPair(PR privateKey, PU publicKey) {
        return (PAIR)((AbstractAsymmetricKeyPair)this.keyPairFactory.createKeyPair(privateKey, publicKey));
    }

    @Override
    public int getKeyLength(PR privateKey) {
        return this.getKeyLength();
    }

    @Override
    public int getKeyLength(PU publicKey) {
        return this.getKeyLength();
    }

    public static AsymmetricKeyCreator<PrivateKey, PublicKey, AsymmetricKeyPairGeneric> of(String algorithm, int keyLength) {
        return AsymmetricKeyCreatorImpl.of(algorithm, keyLength, null, null);
    }

    public static AsymmetricKeyCreator<PrivateKey, PublicKey, AsymmetricKeyPairGeneric> of(String algorithm, int keyLength, RandomFactory randomFactory) {
        return AsymmetricKeyCreatorImpl.of(algorithm, keyLength, null, randomFactory);
    }

    public static AsymmetricKeyCreator<PrivateKey, PublicKey, AsymmetricKeyPairGeneric> of(String algorithm, int keyLength, SecurityProvider provider, RandomFactory randomFactory) {
        if (provider == null) {
            provider = SecurityProvider.DEFAULT;
        }
        KeyFactory keyFactory = provider.createKeyFactory(algorithm);
        return new AsymmetricKeyCreatorImpl<PrivateKey, PublicKey, AsymmetricKeyPairGeneric>(keyFactory, keyLength, provider, AsymmetricKeyPairFactoryGeneric.INSTANCE, randomFactory);
    }
}

