/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.key.ec.jce;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import net.sf.mmm.crypto.asymmetric.key.ec.AsymmetricKeyPairEc;

public class AsymmetricKeyPairEcJce
extends AsymmetricKeyPairEc<ECPrivateKey, ECPublicKey> {
    private static KeyFactory keyFactory;

    public AsymmetricKeyPairEcJce(ECPrivateKey privateKey) {
        super(privateKey, AsymmetricKeyPairEcJce.createPublicKey(privateKey));
    }

    public AsymmetricKeyPairEcJce(ECPrivateKey privateKey, ECPublicKey publicKey) {
        super(privateKey, publicKey);
    }

    public static ECPublicKey createPublicKey(ECPrivateKey privateKey) {
        BigInteger s = privateKey.getS();
        ECParameterSpec ecParameters = privateKey.getParams();
        ECPoint q = null;
        return AsymmetricKeyPairEcJce.createPublicKey(q, ecParameters);
    }

    public static ECPrivateKey createPrivateKey(BigInteger s, ECParameterSpec ecParameters) {
        return AsymmetricKeyPairEcJce.createPrivateKey(new ECPrivateKeySpec(s, ecParameters));
    }

    public static ECPrivateKey createPrivateKey(ECPrivateKeySpec keySpec) {
        return AsymmetricKeyPairEcJce.createPrivateKey(keySpec);
    }

    private static ECPrivateKey createPrivateKey(KeySpec keySpec) {
        try {
            return (ECPrivateKey)AsymmetricKeyPairEcJce.getKeyFactory().generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ECPrivateKey createPrivateKeyFromCompactData(byte[] data, ECParameterSpec ecParameters) {
        BigInteger s = new BigInteger(1, data);
        return AsymmetricKeyPairEcJce.createPrivateKey(s, ecParameters);
    }

    public static ECPrivateKey createPrivateKeyFromEncodedData(byte[] data) {
        return AsymmetricKeyPairEcJce.createPrivateKey(new PKCS8EncodedKeySpec(data));
    }

    public static ECPublicKey createPublicKey(ECPoint w, ECParameterSpec ecParameters) {
        return AsymmetricKeyPairEcJce.createPublicKey(new ECPublicKeySpec(w, ecParameters));
    }

    public static ECPublicKey createPublicKey(ECPublicKeySpec keySpec) {
        return AsymmetricKeyPairEcJce.createPublicKey(keySpec);
    }

    private static ECPublicKey createPublicKey(KeySpec keySpec) {
        try {
            return (ECPublicKey)AsymmetricKeyPairEcJce.getKeyFactory().generatePublic(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ECPublicKey createPublicKeyFromCompactData(byte[] data, ECParameterSpec ecParameters) {
        ECPoint w = null;
        return AsymmetricKeyPairEcJce.createPublicKey(w, ecParameters);
    }

    public static ECPublicKey createPublicKeyFromEncodedData(byte[] data) {
        return AsymmetricKeyPairEcJce.createPublicKey(new X509EncodedKeySpec(data));
    }

    static KeyFactory getKeyFactory() {
        if (keyFactory == null) {
            try {
                keyFactory = KeyFactory.getInstance("EC");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }
        return keyFactory;
    }
}

