/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.key;

import java.security.PrivateKey;
import java.security.PublicKey;
import net.sf.mmm.binary.api.Binary;
import net.sf.mmm.crypto.CryptoBinary;
import net.sf.mmm.crypto.asymmetric.key.AsymmetricKeyPair;
import net.sf.mmm.crypto.asymmetric.key.AsymmetricKeyPairFactory;
import net.sf.mmm.crypto.key.KeyCreator;

public interface AsymmetricKeyCreator<PR extends PrivateKey, PU extends PublicKey, PAIR extends AsymmetricKeyPair<PR, PU>>
extends KeyCreator,
AsymmetricKeyPairFactory<PR, PU, PAIR> {
    public PAIR generateKeyPair();

    @Override
    default public byte[] asData(PR privateKey) {
        return this.asData((PAIR)privateKey, "Compact");
    }

    default public Binary asBinary(PR privateKey, String format) {
        return new CryptoBinary(this.asData((PAIR)privateKey, format));
    }

    public byte[] asData(PR var1, String var2);

    @Override
    default public PR createPrivateKey(byte[] data) {
        return this.createPrivateKey(data, null);
    }

    public PR createPrivateKey(byte[] var1, String var2);

    @Override
    default public byte[] asData(PU publicKey) {
        return this.asData((PAIR)publicKey, "Compact");
    }

    default public Binary asBinary(PU publicKey, String format) {
        return new CryptoBinary(this.asData((PAIR)publicKey, format));
    }

    public byte[] asData(PU var1, String var2);

    @Override
    default public PU createPublicKey(byte[] data) {
        return this.createPublicKey(data, null);
    }

    public PU createPublicKey(byte[] var1, String var2);

    @Override
    default public byte[] asData(PAIR keyPair) {
        return this.asData(keyPair, "Compact");
    }

    default public Binary asBinary(PAIR keyPair, String format) {
        return new CryptoBinary(this.asData(keyPair, format));
    }

    public byte[] asData(PAIR var1, String var2);

    @Override
    default public PAIR createKeyPair(byte[] data) {
        return this.createKeyPair(data, "Compact");
    }

    @Override
    public PAIR createKeyPair(byte[] var1, String var2);

    public int getKeyLength(PR var1);

    default public void verifyKey(PR privateKey) {
        int expectedKeyLength;
        int givenKeyLength = this.getKeyLength((PU)privateKey);
        if (givenKeyLength != (expectedKeyLength = this.getKeyLength())) {
            throw new IllegalArgumentException("Private key has a length of " + givenKeyLength + " bits but expected " + expectedKeyLength + " bits!");
        }
    }

    public int getKeyLength(PU var1);

    default public void verifyKey(PU publicKey) {
        int expectedKeyLength;
        int givenKeyLength = this.getKeyLength(publicKey);
        if (givenKeyLength != (expectedKeyLength = this.getKeyLength())) {
            throw new IllegalArgumentException("Public key has a length of " + givenKeyLength + " bits but expected " + expectedKeyLength + " bits!");
        }
    }
}

