/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.key;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import net.sf.mmm.crypto.asymmetric.key.AbstractAsymmetricKeyPair;
import net.sf.mmm.crypto.asymmetric.key.AsymmetricKeyPairFactory;

public abstract class AbstractAsymmetricKeyPairFactory<PR extends PrivateKey, PU extends PublicKey, PAIR extends AbstractAsymmetricKeyPair<PR, PU>>
implements AsymmetricKeyPairFactory<PR, PU, PAIR> {
    private final KeyFactory keyFactory;

    public AbstractAsymmetricKeyPairFactory(KeyFactory keyFactory) {
        this.keyFactory = keyFactory;
    }

    public KeyFactory getKeyFactory() {
        return this.keyFactory;
    }

    protected PR createPrivateKey(KeySpec keySpec) {
        try {
            return (PR)this.keyFactory.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException("Failed to create private key from spec using algorithm " + this.keyFactory.getAlgorithm() + ".", e);
        }
    }

    protected PU createPublicKey(KeySpec keySpec) {
        try {
            return (PU)this.keyFactory.generatePublic(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException("Failed to create public key from spec using algorithm " + this.keyFactory.getAlgorithm() + ".", e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for " + this.keyFactory.getAlgorithm();
    }
}

