/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.key;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Objects;
import net.sf.mmm.crypto.asymmetric.key.AsymmetricKeyPair;

public abstract class AbstractAsymmetricKeyPair<PR extends PrivateKey, PU extends PublicKey>
implements AsymmetricKeyPair<PR, PU> {
    protected final PR privateKey;
    protected final PU publicKey;
    private final KeyPair keyPair;

    public AbstractAsymmetricKeyPair(PR privateKey, PU publicKey) {
        this(privateKey, publicKey, null);
    }

    public AbstractAsymmetricKeyPair(KeyPair keyPair) {
        Objects.requireNonNull(keyPair, "keyPair");
        this.privateKey = keyPair.getPrivate();
        this.publicKey = keyPair.getPublic();
        Objects.requireNonNull(this.privateKey, "privateKey");
        Objects.requireNonNull(this.publicKey, "publicKey");
        this.keyPair = keyPair;
    }

    public AbstractAsymmetricKeyPair(PR privateKey, PU publicKey, KeyPair keyPair) {
        Objects.requireNonNull(privateKey, "privateKey");
        Objects.requireNonNull(publicKey, "publicKey");
        if (keyPair == null) {
            this.keyPair = new KeyPair((PublicKey)publicKey, (PrivateKey)privateKey);
        } else {
            if (keyPair.getPrivate() != privateKey || keyPair.getPublic() != publicKey) {
                throw new IllegalStateException("KeyPair does not match given keys.");
            }
            this.keyPair = keyPair;
        }
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    @Override
    public PR getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public PU getPublicKey() {
        return this.publicKey;
    }

    @Override
    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public int hashCode() {
        return Objects.hash(this.privateKey, this.publicKey);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof AbstractAsymmetricKeyPair)) {
            return false;
        }
        AbstractAsymmetricKeyPair other = (AbstractAsymmetricKeyPair)obj;
        if (!Objects.equals(this.privateKey, other.privateKey)) {
            return false;
        }
        return Objects.equals(this.publicKey, other.publicKey);
    }
}

