/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.key;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.mmm.crypto.algorithm.CryptoAlgorithmImplWithRandom;
import net.sf.mmm.crypto.asymmetric.key.AbstractAsymmetricKeyPair;
import net.sf.mmm.crypto.asymmetric.key.AsymmetricKeyCreator;
import net.sf.mmm.crypto.asymmetric.key.AsymmetricKeyPair;
import net.sf.mmm.crypto.asymmetric.key.AsymmetricKeyPairFactory;
import net.sf.mmm.crypto.asymmetric.key.generic.AsymmetricKeyPairFactoryEncoded;
import net.sf.mmm.crypto.provider.SecurityProvider;
import net.sf.mmm.crypto.random.RandomFactory;

public abstract class AbstractAsymmetricKeyCreator<PR extends PrivateKey, PU extends PublicKey, PAIR extends AbstractAsymmetricKeyPair<PR, PU>>
extends CryptoAlgorithmImplWithRandom
implements AsymmetricKeyCreator<PR, PU, PAIR> {
    private final Map<String, AsymmetricKeyPairFactory<PR, PU, PAIR>> format2factoryMap;
    private final List<String> formatOrderList;
    private final int keyLength;

    public AbstractAsymmetricKeyCreator(KeyFactory keyFactory, int keyLength, SecurityProvider provider, RandomFactory randomFactory) {
        super(keyFactory.getAlgorithm(), provider, randomFactory);
        this.keyLength = keyLength;
        this.format2factoryMap = new HashMap<String, AsymmetricKeyPairFactory<PR, PU, PAIR>>();
        this.formatOrderList = new ArrayList<String>();
        this.format2factoryMap.put("Encoded", new AsymmetricKeyPairFactoryEncoded(keyFactory, this));
    }

    @Override
    public int getKeyLength() {
        return this.keyLength;
    }

    protected void register(AsymmetricKeyPairFactory<PR, PU, PAIR> factory) {
        this.register(factory, "Compact");
    }

    protected void register(AsymmetricKeyPairFactory<PR, PU, PAIR> factory, String format) {
        AsymmetricKeyPairFactory<PR, PU, PAIR> old = this.format2factoryMap.put(format, factory);
        if (old != null) {
            throw new IllegalStateException("Duplicate format " + format + " registered!");
        }
        this.formatOrderList.add(format);
    }

    private List<String> getFormatOrderList() {
        if (this.formatOrderList.size() < this.format2factoryMap.size()) {
            this.formatOrderList.add("Encoded");
        }
        return this.formatOrderList;
    }

    private AsymmetricKeyPairFactory<PR, PU, PAIR> getKeyPairFactory(String format) {
        AsymmetricKeyPairFactory<PR, PU, PAIR> factory = this.format2factoryMap.get(format);
        if (factory == null) {
            if ("Compact".equals(format)) {
                factory = this.format2factoryMap.get("Encoded");
            }
            if (factory == null) {
                throw new IllegalArgumentException(format);
            }
        }
        return factory;
    }

    @Override
    public PR createPrivateKey(byte[] data, String format) {
        if (format == null) {
            for (String format2detect : this.getFormatOrderList()) {
                PR privateKey = this.createPrivateKey(data, format2detect);
                if (privateKey == null) continue;
                return privateKey;
            }
            throw new IllegalStateException();
        }
        return this.getKeyPairFactory(format).createPrivateKey(data);
    }

    @Override
    public byte[] asData(PR privateKey, String format) {
        return this.getKeyPairFactory(format).asData(privateKey);
    }

    @Override
    public PU createPublicKey(byte[] data, String format) {
        if (format == null) {
            for (String format2detect : this.getFormatOrderList()) {
                PU publicKey = this.createPublicKey(data, format2detect);
                if (publicKey == null) continue;
                return publicKey;
            }
            throw new IllegalStateException();
        }
        return this.getKeyPairFactory(format).createPublicKey(data);
    }

    @Override
    public byte[] asData(PU publicKey, String format) {
        return this.getKeyPairFactory(format).asData(publicKey);
    }

    @Override
    public PAIR createKeyPair(byte[] data, String format) {
        if (format == null) {
            for (String format2detect : this.getFormatOrderList()) {
                AsymmetricKeyPair keyPair = this.createKeyPair(data, format2detect);
                if (keyPair == null) continue;
                return (PAIR)keyPair;
            }
            throw new IllegalStateException();
        }
        return (PAIR)((AbstractAsymmetricKeyPair)this.getKeyPairFactory(format).createKeyPair(data));
    }

    @Override
    public byte[] asData(PAIR keyPair, String format) {
        return this.getKeyPairFactory(format).asData(keyPair);
    }

    @Override
    public PAIR generateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = this.getProvider().createKeyPairGenerator(this.getAlgorithm());
            this.init(keyPairGenerator);
            KeyPair key = keyPairGenerator.generateKeyPair();
            PrivateKey privateKey = key.getPrivate();
            PublicKey publicKey = key.getPublic();
            return (PAIR)((AbstractAsymmetricKeyPair)this.createKeyPair(privateKey, publicKey));
        }
        catch (Exception e) {
            throw this.creationFailedException(e, KeyPair.class);
        }
    }

    protected void init(KeyPairGenerator keyPairGenerator) throws Exception {
        keyPairGenerator.initialize(this.keyLength, this.createSecureRandom());
    }
}

