/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.access.rsa;

import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import net.sf.mmm.crypto.asymmetric.access.AsymmetricAccess;
import net.sf.mmm.crypto.asymmetric.crypt.AsymmetricCryptorConfig;
import net.sf.mmm.crypto.asymmetric.crypt.rsa.AsymmetricCryptorConfigRsa;
import net.sf.mmm.crypto.asymmetric.key.rsa.AsymmetricKeyCreatorRsa;
import net.sf.mmm.crypto.asymmetric.key.rsa.AsymmetricKeyPairRsa;
import net.sf.mmm.crypto.asymmetric.sign.rsa.SignatureConfigRsa;
import net.sf.mmm.crypto.asymmetric.sign.rsa.SignatureRsa;
import net.sf.mmm.crypto.hash.HashConfig;
import net.sf.mmm.crypto.provider.SecurityProvider;
import net.sf.mmm.crypto.random.RandomFactory;

public final class Rsa
extends AsymmetricAccess<SignatureRsa, RSAPrivateKey, RSAPublicKey, AsymmetricKeyPairRsa, AsymmetricKeyCreatorRsa> {
    private final SecurityProvider provider;
    private final int keyLength;

    private Rsa(SignatureConfigRsa signatureConfig, AsymmetricCryptorConfig<RSAPrivateKey, RSAPublicKey> cryptorConfig, RandomFactory randomFactory, int keyLength, SecurityProvider provider) {
        super(signatureConfig, cryptorConfig, randomFactory);
        this.keyLength = keyLength;
        this.provider = provider;
    }

    @Override
    public AsymmetricKeyCreatorRsa newKeyCreator() {
        return new AsymmetricKeyCreatorRsa(this.keyLength, this.provider, this.randomFactory);
    }

    public static Rsa of4096(String hashAlgorithm) {
        return Rsa.of4096(new HashConfig(hashAlgorithm));
    }

    public static Rsa of4096(HashConfig hashConfig) {
        return Rsa.of(4096, hashConfig);
    }

    public static Rsa of(int keyLength, String hashAlgorithm) {
        return Rsa.of(keyLength, new HashConfig(hashAlgorithm));
    }

    public static Rsa of(int keyLength, HashConfig hashConfig) {
        return Rsa.of(keyLength, hashConfig, hashConfig.getAlgorithm(), null, null);
    }

    public static Rsa of(int keyLength, HashConfig hashConfig, RandomFactory randomFactory) {
        return Rsa.of(keyLength, hashConfig, hashConfig.getAlgorithm(), randomFactory, null);
    }

    public static Rsa of(int keyLength, HashConfig hashConfig, String hashAlgorithm, RandomFactory randomFactory, SecurityProvider provider) {
        SignatureConfigRsa signatureConfig = new SignatureConfigRsa(hashConfig, hashAlgorithm, provider);
        AsymmetricCryptorConfigRsa cryptorConfig = new AsymmetricCryptorConfigRsa(provider);
        return new Rsa(signatureConfig, cryptorConfig, randomFactory, keyLength, provider);
    }
}

