/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.access;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.sf.mmm.crypto.CryptoAccess;
import net.sf.mmm.crypto.asymmetric.crypt.AsymmetricCryptorConfig;
import net.sf.mmm.crypto.asymmetric.crypt.AsymmetricCryptorFactory;
import net.sf.mmm.crypto.asymmetric.key.AsymmetricKeyCreator;
import net.sf.mmm.crypto.asymmetric.key.AsymmetricKeyCreatorFactory;
import net.sf.mmm.crypto.asymmetric.key.AsymmetricKeyPair;
import net.sf.mmm.crypto.asymmetric.sign.SignatureBinary;
import net.sf.mmm.crypto.asymmetric.sign.SignatureConfig;
import net.sf.mmm.crypto.asymmetric.sign.SignatureProcessorFactory;
import net.sf.mmm.crypto.asymmetric.sign.SignatureProcessorFactoryImpl;
import net.sf.mmm.crypto.asymmetric.sign.SignatureSigner;
import net.sf.mmm.crypto.asymmetric.sign.SignatureVerifier;
import net.sf.mmm.crypto.crypt.Decryptor;
import net.sf.mmm.crypto.crypt.DecryptorImplCipher;
import net.sf.mmm.crypto.crypt.Encryptor;
import net.sf.mmm.crypto.crypt.EncryptorImplCiper;
import net.sf.mmm.crypto.hash.HashCreator;
import net.sf.mmm.crypto.hash.HashFactory;
import net.sf.mmm.crypto.hash.access.HashAccess;
import net.sf.mmm.crypto.random.RandomFactory;

public abstract class AsymmetricAccess<S extends SignatureBinary, PR extends PrivateKey, PU extends PublicKey, PAIR extends AsymmetricKeyPair<PR, PU>, KC extends AsymmetricKeyCreator<PR, PU, PAIR>>
extends CryptoAccess
implements AsymmetricKeyCreatorFactory<KC>,
AsymmetricCryptorFactory<PR, PU>,
SignatureProcessorFactory<S, PR, PU>,
HashFactory {
    protected final AsymmetricCryptorConfig<PR, PU> cryptorConfig;
    private final SignatureConfig<S> signatureConfig;
    protected final RandomFactory randomFactory;
    private final SignatureProcessorFactory<S, PR, PU> signatureFactory;
    private final HashAccess hashFactory;
    private KC keyCreator;

    public AsymmetricAccess(SignatureConfig<S> signatureConfig, AsymmetricCryptorConfig<PR, PU> cryptorConfig, RandomFactory randomFactory) {
        this(signatureConfig, null, cryptorConfig, randomFactory);
    }

    public AsymmetricAccess(SignatureConfig<S> signatureConfig, SignatureProcessorFactory<S, PR, PU> signatureFactory, AsymmetricCryptorConfig<PR, PU> cryptorConfig, RandomFactory randomFactory) {
        this.signatureConfig = signatureConfig;
        this.signatureFactory = signatureFactory == null ? new SignatureProcessorFactoryImpl(signatureConfig, randomFactory) : signatureFactory;
        this.cryptorConfig = cryptorConfig;
        this.randomFactory = randomFactory;
        this.hashFactory = new HashAccess(signatureConfig.getHashConfig());
    }

    public SignatureConfig<S> getSignatureConfig() {
        return this.signatureConfig;
    }

    public AsymmetricCryptorConfig<PR, PU> getCryptorConfig() {
        return this.cryptorConfig;
    }

    private KC getKeyCreatorInternal() {
        if (this.keyCreator == null) {
            this.keyCreator = this.newKeyCreator();
        }
        return this.keyCreator;
    }

    @Override
    public Decryptor newDecryptorUnsafe(Key decryptionKey) {
        return new DecryptorImplCipher(this.randomFactory, this.cryptorConfig, decryptionKey);
    }

    @Override
    public Decryptor newDecryptor(PR privateKey) {
        this.getKeyCreatorInternal().verifyKey(privateKey);
        return this.newDecryptorUnsafe((Key)privateKey);
    }

    @Override
    public Encryptor newEncryptorUnsafe(Key encryptionKey) {
        return new EncryptorImplCiper(this.randomFactory, this.cryptorConfig, encryptionKey);
    }

    @Override
    public Encryptor newEncryptor(PU publicKey) {
        this.getKeyCreatorInternal().verifyKey(publicKey);
        return this.newEncryptorUnsafe((Key)publicKey);
    }

    @Override
    public SignatureSigner<S> newSigner(PR privateKey) {
        this.getKeyCreatorInternal().verifyKey(privateKey);
        return this.signatureFactory.newSigner(privateKey);
    }

    @Override
    public SignatureVerifier<S> newVerifier(PU publicKey) {
        this.getKeyCreatorInternal().verifyKey(publicKey);
        return this.signatureFactory.newVerifier(publicKey);
    }

    @Override
    public S createSignature(byte[] data) {
        return this.signatureFactory.createSignature(data);
    }

    @Override
    public HashCreator newHashCreator() {
        return this.hashFactory.newHashCreator();
    }

    @Override
    public SignatureProcessorFactory<S, PR, PU> getSignatureFactoryWithoutHash() {
        return this.signatureFactory.getSignatureFactoryWithoutHash();
    }
}

