/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.algorithm;

import java.security.InvalidKeyException;
import net.sf.mmm.crypto.algorithm.CryptoAlgorithm;

public abstract class AbstractSecurityAlgorithm
implements CryptoAlgorithm {
    protected static String getAlgorithm(CryptoAlgorithm[] algorithms) {
        StringBuilder buffer = new StringBuilder();
        for (CryptoAlgorithm algorithm : algorithms) {
            if (buffer.length() > 0) {
                buffer.append('+');
            }
            buffer.append(algorithm);
        }
        return buffer.toString();
    }

    protected RuntimeException creationFailedException(Exception cause, Class<?> objectType) {
        return this.creationFailedException(cause, objectType.getSimpleName());
    }

    protected RuntimeException creationFailedException(Exception cause, String objectType) {
        return AbstractSecurityAlgorithm.creationFailedException(cause, objectType, this.getAlgorithm());
    }

    public static RuntimeException creationFailedException(Exception cause, Class<?> objectType, String variant) {
        return AbstractSecurityAlgorithm.creationFailedException(cause, objectType.getSimpleName(), variant);
    }

    public static RuntimeException creationFailedException(Exception cause, String objectType, String variant) {
        String suffix = "";
        boolean limitedJurisdictionPolicy = false;
        if (cause instanceof InvalidKeyException) {
            if (cause.getMessage().contains("key size")) {
                limitedJurisdictionPolicy = true;
            }
        } else if (cause instanceof IllegalArgumentException && cause.getMessage().contains("not an EC key")) {
            limitedJurisdictionPolicy = true;
        }
        if (limitedJurisdictionPolicy) {
            suffix = " Thanks to U.S. law (see https://en.wikipedia.org/wiki/Export_of_cryptography_from_the_United_States) your Java installation has limited cryptography and prevents secure encryption. To resolve this problem upgrade to a most recent version of Java. Otherwise you have to install Jurisdiction Policy Files (http://www.oracle.com/technetwork/java/javase/downloads/jce-6-download-429243.html).";
        }
        return new IllegalStateException("Failed to create " + objectType + " for '" + variant + "'." + suffix, cause);
    }

    public String toString() {
        return this.getAlgorithm();
    }
}

