/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto;

import net.sf.mmm.crypto.CryptoBinary;
import net.sf.mmm.crypto.algorithm.CryptoAlgorithm;

public interface CryptoProcessor
extends CryptoAlgorithm {
    default public byte[] process(byte[] input) {
        return this.process(input, 0, input.length);
    }

    default public byte[] process(byte[] input, int offset, int length) {
        return this.process(input, offset, length, true);
    }

    default public byte[] process(byte[] input, int offset, int length, boolean complete) {
        throw new UnsupportedOperationException();
    }

    default public byte[] process(CryptoBinary input, boolean complete) {
        byte[] data = input.getRawData();
        return this.process(data, 0, data.length, complete);
    }

    public void reset();
}

