/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.symmetric.access.pbe;

import net.sf.mmm.crypto.provider.BouncyCastle;
import net.sf.mmm.crypto.symmetric.access.pbe.PbeAccess;
import net.sf.mmm.crypto.symmetric.crypt.SymmetricCryptorConfig;
import net.sf.mmm.crypto.symmetric.crypt.aes.SymmetricCryptorConfigAes;
import net.sf.mmm.crypto.symmetric.key.pbe.SymmetricKeyConfigPbe;

public class Pbkdf2
extends PbeAccess {
    static final SymmetricCryptorConfigAes CRYPTOR_CONFIG_AES = new SymmetricCryptorConfigAes(BouncyCastle.getSecurityProvider());

    Pbkdf2(SymmetricKeyConfigPbe keyConfig) {
        super(keyConfig, (SymmetricCryptorConfig)CRYPTOR_CONFIG_AES);
    }

    Pbkdf2(SymmetricKeyConfigPbe keyConfig, SymmetricCryptorConfig cryptorConfig) {
        super(keyConfig, cryptorConfig);
    }

    Pbkdf2(String keyAlgorithm, int keyLength) {
        this(keyAlgorithm, keyLength, (SymmetricCryptorConfig)CRYPTOR_CONFIG_AES);
    }

    Pbkdf2(String keyAlgorithm, int keyLength, SymmetricCryptorConfig cryptorConfig) {
        super(new SymmetricKeyConfigPbe(keyAlgorithm, BouncyCastle.getSecurityProvider(), keyLength), cryptorConfig);
    }
}

