/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.provider;

import java.security.Provider;
import java.security.Security;
import net.sf.mmm.crypto.provider.SecurityProvider;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BouncyCastle {
    private static final Logger LOG = LoggerFactory.getLogger(BouncyCastle.class);
    private static boolean installed = false;
    private static final BouncyCastleProvider PROVIDER = new BouncyCastleProvider();
    private static final SecurityProvider SECURITY_PROVIDER = SecurityProvider.of((Provider)PROVIDER);

    public static void install() {
        if (!installed && Security.getProvider("BC") == null) {
            Security.addProvider((Provider)PROVIDER);
            LOG.debug("Successfully installed bouncy castle provider to java security.");
        }
    }

    public static BouncyCastleProvider getProvider() {
        return PROVIDER;
    }

    public static SecurityProvider getSecurityProvider() {
        return SECURITY_PROVIDER;
    }
}

