/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.sign.ec.bc;

import net.sf.mmm.crypto.asymmetric.sign.SignatureConfig;
import net.sf.mmm.crypto.asymmetric.sign.SignatureProcessor;
import net.sf.mmm.crypto.asymmetric.sign.ec.SignatureConfigEcDsa;
import net.sf.mmm.crypto.asymmetric.sign.ec.bc.SignatureEcBc;
import net.sf.mmm.crypto.asymmetric.sign.ec.bc.SignatureFactoryEcBc;
import org.bouncycastle.crypto.signers.ECDSASigner;

public abstract class SignatureProcessorImplEcBc<S extends SignatureEcBc>
implements SignatureProcessor {
    private final SignatureConfig<S> config;
    private final SignatureFactoryEcBc<S> signatureFactory;
    protected final ECDSASigner signer;
    protected byte[] data;

    public SignatureProcessorImplEcBc(SignatureConfigEcDsa<S> config, ECDSASigner signer) {
        this.config = config;
        this.signatureFactory = (SignatureFactoryEcBc)config.getSignatureFactory();
        this.signer = signer;
    }

    public String getAlgorithm() {
        return this.config.getAlgorithm();
    }

    public SignatureConfig<S> getConfig() {
        return this.config;
    }

    public SignatureFactoryEcBc<S> getSignatureFactory() {
        return this.signatureFactory;
    }

    public void update(byte[] input, int offset, int length) {
        if (this.data != null) {
            throw new IllegalStateException("This implementation does not allow sequential updating. Please combine with hash algorithm.");
        }
        if (offset == 0 && length == input.length) {
            this.data = input;
        } else {
            this.data = new byte[length];
            System.arraycopy(input, offset, this.data, 0, length);
        }
    }

    public void reset() {
    }
}

