/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.sign.ec.bc;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import net.sf.mmm.crypto.algorithm.AbstractSecurityAlgorithm;
import net.sf.mmm.crypto.asymmetric.key.ec.bc.AsymmetricKeyPairEcBc;
import net.sf.mmm.crypto.asymmetric.sign.SignatureProcessorFactory;
import net.sf.mmm.crypto.asymmetric.sign.SignatureSigner;
import net.sf.mmm.crypto.asymmetric.sign.SignatureSignerImplWithHash;
import net.sf.mmm.crypto.asymmetric.sign.SignatureVerifier;
import net.sf.mmm.crypto.asymmetric.sign.SignatureVerifierImplWithHash;
import net.sf.mmm.crypto.asymmetric.sign.ec.SignatureConfigEcDsa;
import net.sf.mmm.crypto.asymmetric.sign.ec.bc.SignatureEcBc;
import net.sf.mmm.crypto.asymmetric.sign.ec.bc.SignatureSignerImplEcBc;
import net.sf.mmm.crypto.asymmetric.sign.ec.bc.SignatureVerifierImplEcBc;
import net.sf.mmm.crypto.hash.HashConfig;
import net.sf.mmm.crypto.hash.HashCreator;
import net.sf.mmm.crypto.hash.HashCreatorImplDigest;
import net.sf.mmm.crypto.hash.HashCreatorImplMultipleRounds;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jcajce.provider.util.DigestFactory;

public class SignatureProcessorFactoryImplEcBc<S extends SignatureEcBc>
extends AbstractSecurityAlgorithm
implements SignatureProcessorFactory<S, BCECPrivateKey, BCECPublicKey> {
    private final SignatureConfigEcDsa<S> config;

    public SignatureProcessorFactoryImplEcBc(SignatureConfigEcDsa<S> config) {
        this.config = config;
    }

    public String getAlgorithm() {
        return this.config.getAlgorithm();
    }

    private HashCreator newPreHashCreator() {
        HashConfig hashConfig = this.config.getHashConfig();
        if (hashConfig != null) {
            int iterationCount = hashConfig.getIterationCount();
            if (iterationCount == 1) {
                return new HashCreatorImplDigest(hashConfig.getAlgorithm(), null);
            }
            if (iterationCount > 1) {
                return new HashCreatorImplMultipleRounds(hashConfig.getAlgorithm(), null, iterationCount);
            }
        }
        return null;
    }

    public SignatureSigner<S> newSigner(BCECPrivateKey privateKey) {
        try {
            Digest digest = SignatureProcessorFactoryImplEcBc.createDigest(this.config.getSignatureAlgorithm().getHashAlgorithm());
            ECDSASigner ecSigner = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator(digest));
            AsymmetricKeyParameter privKeyParams = ECUtil.generatePrivateKeyParameter((PrivateKey)privateKey);
            ecSigner.init(true, (CipherParameters)privKeyParams);
            BCECPublicKey publicKey = AsymmetricKeyPairEcBc.createPublicKey(privateKey);
            SignatureSignerImplWithHash signer = new SignatureSignerImplEcBc(this.config, ecSigner, publicKey);
            HashCreator hashGenerator = this.newPreHashCreator();
            if (hashGenerator != null) {
                signer = new SignatureSignerImplWithHash(hashGenerator, signer);
            }
            return signer;
        }
        catch (Exception e) {
            throw this.creationFailedException(e, Signature.class);
        }
    }

    private static Digest createDigest(String algorithm) {
        Digest digest = DigestFactory.getDigest((String)algorithm);
        if (digest == null) {
            throw new IllegalArgumentException(algorithm);
        }
        return digest;
    }

    public SignatureVerifier<S> newVerifier(BCECPublicKey publicKey) {
        try {
            ECDSASigner signer = new ECDSASigner();
            AsymmetricKeyParameter publicKeyParameters = ECUtil.generatePublicKeyParameter((PublicKey)publicKey);
            signer.init(false, (CipherParameters)publicKeyParameters);
            SignatureVerifierImplWithHash verifier = new SignatureVerifierImplEcBc(this.config, signer);
            HashCreator hashGenerator = this.newPreHashCreator();
            if (hashGenerator != null) {
                verifier = new SignatureVerifierImplWithHash(hashGenerator, verifier);
            }
            return verifier;
        }
        catch (Exception e) {
            throw this.creationFailedException(e, Signature.class);
        }
    }

    public S createSignature(byte[] data) {
        return (S)((Object)((SignatureEcBc)this.config.getSignatureFactory().createSignature(data)));
    }

    public SignatureProcessorFactory<S, BCECPrivateKey, BCECPublicKey> getSignatureFactoryWithoutHash() {
        if (this.config.getHashConfig() == null) {
            return this;
        }
        return new SignatureProcessorFactoryImplEcBc<S>(this.config.withoutHashConfig());
    }
}

