/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.sign.ec.bc;

import java.math.BigInteger;
import net.sf.mmm.crypto.asymmetric.access.ec.bc.CryptoEllipticCurveBc;
import net.sf.mmm.crypto.asymmetric.sign.SignatureWithPublicKeyRecovery;
import net.sf.mmm.crypto.asymmetric.sign.ec.bc.SignatureEcBc;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;

public class SignatureEcBcWithRecoveryId
extends SignatureEcBc
implements SignatureWithPublicKeyRecovery {
    public static final byte BITCOIN_RECOVERY_OFFSET = 27;
    public static final byte BITCOIN_COMPRESSED_OFFSET = 4;
    private static final int HEAD = 1;
    private final byte recoveryOffset;

    protected SignatureEcBcWithRecoveryId(CryptoEllipticCurveBc curve, byte[] data, BigInteger r, BigInteger s, byte recoveryOffset) {
        super(curve, data, r, s);
        this.recoveryOffset = recoveryOffset;
    }

    public SignatureEcBcWithRecoveryId(CryptoEllipticCurveBc curve, byte[] data, byte recoveryOffset) {
        super(curve, data);
        this.recoveryOffset = recoveryOffset;
    }

    @Override
    protected int getHead() {
        return 1;
    }

    public byte getRecoveryId() {
        return this.data[0];
    }

    public byte getRecoveryIndex() {
        int recoveryIndex = this.data[0] - this.recoveryOffset;
        return (byte)(recoveryIndex %= 4);
    }

    protected byte getRecoveryOffset() {
        return this.recoveryOffset;
    }

    public boolean isCompressed() {
        return this.data[0] - this.recoveryOffset >= 4;
    }

    public BCECPublicKey recoverPublicKey(byte[] message) {
        BCECPublicKey publicKey = this.recoverPublicKey(message, this.getRecoveryIndex());
        if (publicKey != null) {
            return publicKey;
        }
        throw new IllegalArgumentException("Can not recover public key from signature. Most probably you did not provide the same playload as when creating the signature.");
    }

    public static SignatureEcBcWithRecoveryId of(CryptoEllipticCurveBc curve, BigInteger r, BigInteger s, byte[] message, BCECPublicKey publicKey, byte recoveryOffset) {
        BigInteger sCanonical = s;
        BigInteger halfN = curve.getHalfN();
        if (halfN != null && s.compareTo(halfN) > 0) {
            sCanonical = curve.getEcParameters().getN().subtract(s);
        }
        byte[] data = SignatureEcBcWithRecoveryId.createData(1, r, sCanonical);
        byte recoveryIndex = SignatureEcBcWithRecoveryId.calculateRecoveryIndex(message, curve, r, sCanonical, publicKey);
        int recoveryId = recoveryIndex + recoveryOffset;
        data[0] = (byte)recoveryId;
        return new SignatureEcBcWithRecoveryId(curve, data, r, sCanonical, recoveryOffset);
    }
}

