/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.sign.ec.bc;

import java.math.BigInteger;
import net.sf.mmm.crypto.asymmetric.access.ec.bc.CryptoEllipticCurveBc;
import net.sf.mmm.crypto.asymmetric.key.ec.bc.AsymmetricKeyPairEcBc;
import net.sf.mmm.crypto.asymmetric.sign.SignatureBinary;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;

public abstract class SignatureEcBc
extends SignatureBinary {
    private final CryptoEllipticCurveBc curve;
    private BigInteger r;
    private BigInteger s;

    public SignatureEcBc(CryptoEllipticCurveBc curve, byte[] data, BigInteger r, BigInteger s) {
        super(data);
        this.curve = curve;
        this.r = r;
        this.s = s;
    }

    public SignatureEcBc(CryptoEllipticCurveBc curve, byte[] data) {
        super(data);
        this.curve = curve;
    }

    private void initRS() {
        if (this.r == null) {
            assert (this.s == null);
            this.deserialize();
        } else assert (this.s != null);
    }

    protected int getHead() {
        return 0;
    }

    protected void deserialize() {
        int len = this.data.length;
        int head = this.getHead();
        int rsLen = len - head;
        if (rsLen % 2 != 0) {
            throw new IllegalStateException("Invalid signature length: " + len);
        }
        int biLen = rsLen / 2;
        byte[] biData = new byte[biLen];
        System.arraycopy(this.data, head, biData, 0, biLen);
        this.r = new BigInteger(1, biData);
        System.arraycopy(this.data, head + biLen, biData, 0, biLen);
        this.s = new BigInteger(1, biData);
    }

    protected static byte[] createData(int head, BigInteger r, BigInteger s) {
        int maxLen;
        byte[] rData = r.toByteArray();
        byte[] sData = s.toByteArray();
        int rStart = 0;
        int rLen = rData.length;
        if (rData[0] == 0) {
            rStart = 1;
            --rLen;
        }
        int sStart = 0;
        int sLen = sData.length;
        if (sData[0] == 0) {
            sStart = 1;
            --sLen;
        }
        if ((maxLen = rLen) < sLen) {
            maxLen = sLen;
        }
        byte[] data = new byte[head + maxLen + maxLen];
        System.arraycopy(rData, rStart, data, head, rLen);
        System.arraycopy(sData, sStart, data, head + maxLen, sLen);
        return data;
    }

    public BigInteger getR() {
        this.initRS();
        return this.r;
    }

    public BigInteger getS() {
        this.initRS();
        return this.s;
    }

    protected CryptoEllipticCurveBc getCurve() {
        return this.curve;
    }

    protected BCECPublicKey recoverPublicKey(byte[] message, byte recoveryIndex) {
        this.initRS();
        return SignatureEcBc.recoverPublicKey(message, this.curve, this.r, this.s, recoveryIndex);
    }

    protected static byte calculateRecoveryIndex(byte[] message, CryptoEllipticCurveBc curve, BigInteger r, BigInteger s, BCECPublicKey publicKey) {
        byte recoveryIndex = -1;
        for (byte i = 0; i < 4; i = (byte)(i + 1)) {
            BCECPublicKey key = SignatureEcBc.recoverPublicKey(message, curve, r, s, i);
            if (key == null || !key.getQ().equals(publicKey.getQ())) continue;
            recoveryIndex = i;
            break;
        }
        if (recoveryIndex == -1) {
            throw new IllegalArgumentException("Failed to recover public key from signature.");
        }
        return recoveryIndex;
    }

    protected static BCECPublicKey recoverPublicKey(byte[] message, CryptoEllipticCurveBc curve, BigInteger r, BigInteger s, byte recoveryIndex) {
        ECPoint ecPoint;
        BigInteger qCurve;
        BigInteger e = new BigInteger(1, message);
        ECParameterSpec ecParameters = curve.getEcParameters();
        BigInteger n = ecParameters.getN();
        BigInteger x = r;
        if (recoveryIndex > 2) {
            x = r.add(n);
        }
        if (x.compareTo(qCurve = curve.getQ()) >= 0) {
            return null;
        }
        ECCurve ecCurve = ecParameters.getCurve();
        ECFieldElement xCurve = ecCurve.fromBigInteger(x);
        ECFieldElement alpha = xCurve.multiply(xCurve.square().add(ecCurve.getA())).add(ecCurve.getB());
        ECFieldElement beta = alpha.sqrt();
        if (beta == null) {
            throw new IllegalStateException();
        }
        BigInteger nBeta = beta.toBigInteger();
        if (nBeta.testBit(0) == ((recoveryIndex & 1) == 1)) {
            ecPoint = ecCurve.createPoint(xCurve.toBigInteger(), nBeta);
        } else {
            ECFieldElement y = ecCurve.fromBigInteger(qCurve.subtract(nBeta));
            ecPoint = ecCurve.createPoint(xCurve.toBigInteger(), y.toBigInteger());
        }
        if (!ecPoint.multiply(n).isInfinity()) {
            return null;
        }
        BigInteger eInverse = BigInteger.ZERO.subtract(e).mod(n);
        BigInteger rInverse = r.modInverse(n);
        BigInteger srInverse = rInverse.multiply(s).mod(n);
        BigInteger erInverse = rInverse.multiply(eInverse).mod(n);
        ECPoint qKey = ECAlgorithms.sumOfTwoMultiplies((ECPoint)ecParameters.getG(), (BigInteger)erInverse, (ECPoint)ecPoint, (BigInteger)srInverse);
        return AsymmetricKeyPairEcBc.createPublicKey(qKey, ecParameters);
    }
}

