/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.key.ec.bc;

import java.math.BigInteger;
import java.security.KeyFactory;
import net.sf.mmm.crypto.asymmetric.access.ec.bc.CryptoEllipticCurveBc;
import net.sf.mmm.crypto.asymmetric.key.AbstractAsymmetricKeyPairFactory;
import net.sf.mmm.crypto.asymmetric.key.ec.bc.AsymmetricKeyPairEcBc;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.spec.ECParameterSpec;

public abstract class AsymmetricKeyPairFactoryEcBc
extends AbstractAsymmetricKeyPairFactory<BCECPrivateKey, BCECPublicKey, AsymmetricKeyPairEcBc> {
    protected final ECParameterSpec ecParameters;
    protected final int byteLength;

    public AsymmetricKeyPairFactoryEcBc(ECParameterSpec ecParameters) {
        this(ecParameters, AsymmetricKeyPairEcBc.getKeyFactory());
    }

    public AsymmetricKeyPairFactoryEcBc(ECParameterSpec ecParameters, KeyFactory keyFactory) {
        super(keyFactory);
        this.ecParameters = ecParameters;
        this.byteLength = CryptoEllipticCurveBc.getByteLength(this.ecParameters);
    }

    public byte[] asData(BCECPrivateKey privateKey) {
        byte[] data = privateKey.getD().toByteArray();
        if (data[0] == 0) {
            byte[] compactData = new byte[data.length - 1];
            System.arraycopy(data, 1, compactData, 0, compactData.length);
            data = compactData;
        }
        return data;
    }

    public BCECPrivateKey createPrivateKey(byte[] data) {
        if (data.length > this.byteLength) {
            return null;
        }
        BigInteger s = new BigInteger(1, data);
        return AsymmetricKeyPairEcBc.createPrivateKey(s, this.ecParameters);
    }

    public byte[] asData(AsymmetricKeyPairEcBc keyPair) {
        return this.asData((BCECPrivateKey)keyPair.getPrivateKey());
    }

    public AsymmetricKeyPairEcBc createKeyPair(byte[] data) {
        BCECPrivateKey privateKey = this.createPrivateKey(data);
        return new AsymmetricKeyPairEcBc(privateKey);
    }

    public AsymmetricKeyPairEcBc createKeyPair(BCECPrivateKey privateKey, BCECPublicKey publicKey) {
        return new AsymmetricKeyPairEcBc(privateKey, publicKey);
    }
}

