/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.key.ec.bc;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import net.sf.mmm.crypto.asymmetric.key.ec.AsymmetricKeyPairEc;
import net.sf.mmm.crypto.provider.BouncyCastle;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;

public class AsymmetricKeyPairEcBc
extends AsymmetricKeyPairEc<BCECPrivateKey, BCECPublicKey> {
    private static KeyFactory keyFactory;

    public AsymmetricKeyPairEcBc(BCECPrivateKey privateKey) {
        super((ECPrivateKey)privateKey, (ECPublicKey)AsymmetricKeyPairEcBc.createPublicKey(privateKey));
    }

    public AsymmetricKeyPairEcBc(BCECPrivateKey privateKey, BCECPublicKey publicKey) {
        super((ECPrivateKey)privateKey, (ECPublicKey)publicKey);
    }

    static KeyFactory getKeyFactory() {
        if (keyFactory == null) {
            try {
                keyFactory = KeyFactory.getInstance("EC", (Provider)BouncyCastle.getProvider());
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }
        return keyFactory;
    }

    public static BCECPrivateKey createPrivateKey(BigInteger s, ECParameterSpec ecParameters) {
        return AsymmetricKeyPairEcBc.createPrivateKey(new ECPrivateKeySpec(s, ecParameters));
    }

    public static BCECPrivateKey createPrivateKey(ECPrivateKeySpec keySpec) {
        return new BCECPrivateKey("EC", keySpec, BouncyCastleProvider.CONFIGURATION);
    }

    private static BCECPrivateKey createPrivateKey(KeySpec keySpec) {
        try {
            return (BCECPrivateKey)AsymmetricKeyPairEcBc.getKeyFactory().generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static BCECPrivateKey createPrivateKeyFromEncodedData(byte[] data) {
        return AsymmetricKeyPairEcBc.createPrivateKey(new PKCS8EncodedKeySpec(data));
    }

    public static BCECPublicKey createPublicKey(BCECPrivateKey privateKey) {
        BigInteger s = privateKey.getS();
        ECParameterSpec ecParameters = privateKey.getParameters();
        ECPoint q = ecParameters.getG().multiply(s);
        return AsymmetricKeyPairEcBc.createPublicKey(q, ecParameters);
    }

    public static BCECPublicKey createPublicKey(ECPoint q, ECParameterSpec ecParameters) {
        return AsymmetricKeyPairEcBc.createPublicKey(new ECPublicKeySpec(q, ecParameters));
    }

    public static BCECPublicKey createPublicKey(ECPublicKeySpec keySpec) {
        return new BCECPublicKey("EC", keySpec, BouncyCastleProvider.CONFIGURATION);
    }

    private static BCECPublicKey createPublicKey(KeySpec keySpec) {
        try {
            return (BCECPublicKey)AsymmetricKeyPairEcBc.getKeyFactory().generatePublic(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static BCECPublicKey createPublicKeyFromEncodedData(byte[] data) {
        return AsymmetricKeyPairEcBc.createPublicKey(new X509EncodedKeySpec(data));
    }
}

