/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.key.ec.bc;

import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;
import net.sf.mmm.crypto.asymmetric.key.AbstractAsymmetricKeyCreator;
import net.sf.mmm.crypto.asymmetric.key.AsymmetricKeyPairFactory;
import net.sf.mmm.crypto.asymmetric.key.ec.bc.AsymmetricKeyPairEcBc;
import net.sf.mmm.crypto.asymmetric.key.ec.bc.AsymmetricKeyPairFactoryEcBcCompact;
import net.sf.mmm.crypto.asymmetric.key.ec.bc.AsymmetricKeyPairFactoryEcBcUncompressed;
import net.sf.mmm.crypto.provider.BouncyCastle;
import net.sf.mmm.crypto.provider.SecurityProvider;
import net.sf.mmm.crypto.random.RandomFactory;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.spec.ECParameterSpec;

public class AsymmetricKeyCreatorEcBc
extends AbstractAsymmetricKeyCreator<BCECPrivateKey, BCECPublicKey, AsymmetricKeyPairEcBc> {
    private final ECParameterSpec ecParameters;

    public AsymmetricKeyCreatorEcBc(ECParameterSpec ecParameters) {
        this(ecParameters, null);
    }

    public AsymmetricKeyCreatorEcBc(ECParameterSpec ecParameters, RandomFactory randomFactory) {
        super(AsymmetricKeyPairEcBc.getKeyFactory(), ecParameters.getCurve().getOrder().bitLength(), SecurityProvider.of((Provider)BouncyCastle.getProvider()), randomFactory);
        this.ecParameters = ecParameters;
        this.register((AsymmetricKeyPairFactory)new AsymmetricKeyPairFactoryEcBcCompact(ecParameters));
        this.register((AsymmetricKeyPairFactory)new AsymmetricKeyPairFactoryEcBcUncompressed(ecParameters), "Uncompressed");
    }

    public AsymmetricKeyPairEcBc createKeyPair(BCECPrivateKey privateKey, BCECPublicKey publicKey) {
        return new AsymmetricKeyPairEcBc(privateKey, publicKey);
    }

    public int getKeyLength(BCECPrivateKey privateKey) {
        Objects.requireNonNull(privateKey, "privateKey");
        return privateKey.getParameters().getCurve().getOrder().bitLength();
    }

    public void verifyKey(BCECPrivateKey privateKey) {
        super.verifyKey((PrivateKey)privateKey);
        if (!Objects.equals(this.ecParameters, privateKey.getParameters())) {
            throw new IllegalArgumentException("PRivate key has different elliptic curve!");
        }
    }

    public int getKeyLength(BCECPublicKey publicKey) {
        Objects.requireNonNull(publicKey, "publicKey");
        return publicKey.getParameters().getCurve().getOrder().bitLength();
    }

    public void verifyKey(BCECPublicKey publicKey) {
        super.verifyKey((PublicKey)publicKey);
        if (!Objects.equals(this.ecParameters, publicKey.getParameters())) {
            throw new IllegalArgumentException("Public key has different elliptic curve!");
        }
    }

    protected void init(KeyPairGenerator keyPairGenerator) throws Exception {
        keyPairGenerator.initialize((AlgorithmParameterSpec)this.ecParameters, this.createSecureRandom());
    }
}

