/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.cert;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import net.sf.mmm.crypto.algorithm.AbstractSecurityAlgorithm;
import net.sf.mmm.crypto.asymmetric.cert.CertificateConfig;
import net.sf.mmm.crypto.asymmetric.cert.CertificateCreator;
import net.sf.mmm.crypto.asymmetric.cert.CertificateData;
import net.sf.mmm.crypto.asymmetric.cert.CertificateDataBean;
import net.sf.mmm.crypto.asymmetric.key.AsymmetricKeyPair;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class CertificateCreatorImpl
extends AbstractSecurityAlgorithm
implements CertificateCreator {
    private final CertificateConfig config;
    private CertificateFactory certificateFactory;

    public CertificateCreatorImpl(CertificateConfig config) {
        this.config = config;
    }

    public String getAlgorithm() {
        return this.config.getType();
    }

    protected CertificateFactory getCertificateFactory() {
        if (this.certificateFactory == null) {
            this.certificateFactory = this.config.getProvider().createCertificateFactory(this.config.getType());
        }
        return this.certificateFactory;
    }

    public Certificate createCertificate(byte[] certificateData) {
        Certificate certificate;
        ByteArrayInputStream in = new ByteArrayInputStream(certificateData);
        try {
            certificate = this.getCertificateFactory().generateCertificate(in);
        }
        catch (Exception e) {
            throw this.creationFailedException(e, Certificate.class);
        }
        return certificate;
    }

    public Certificate generateCertificate(AsymmetricKeyPair<?, ?> keyPair, CertificateData certificateData) {
        String type = this.config.getType();
        if (!type.equals("X509")) {
            throw new UnsupportedOperationException("Unsupported certificate type: " + type);
        }
        try {
            PublicKey publicKey = keyPair.getPublicKey();
            PrivateKey privateKey = keyPair.getPrivateKey();
            SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
            X500Name subject = new X500Name(certificateData.getSubject());
            Date notAfter = Date.from(certificateData.getNotAfter());
            Date notBefore = Date.from(certificateData.getNotBefore());
            X500Name issuer = new X500Name(certificateData.getIssuer());
            BigInteger serial = certificateData.getSerialNumber();
            X509v3CertificateBuilder builder = new X509v3CertificateBuilder(issuer, serial, notBefore, notAfter, subject, publicKeyInfo);
            ContentSigner signer = new JcaContentSignerBuilder(certificateData.getSignatureAlgorithm()).build(privateKey);
            X509CertificateHolder certificateHolder = builder.build(signer);
            X509Certificate certificate = new JcaX509CertificateConverter().getCertificate(certificateHolder);
            return certificate;
        }
        catch (Exception e) {
            throw AbstractSecurityAlgorithm.creationFailedException((Exception)e, Certificate.class, (String)type);
        }
    }

    public CertificateData getCertificateData(Certificate certificate) {
        if (certificate instanceof X509Certificate) {
            String signatureAlgorithmName;
            BigInteger serialNumber;
            X500Principal subject;
            X500Principal issuer;
            Date notBefore;
            X509Certificate x509Certificate = (X509Certificate)certificate;
            CertificateDataBean dataBean = new CertificateDataBean();
            Date notAfter = x509Certificate.getNotAfter();
            if (notAfter != null) {
                dataBean.setNotAfter(notAfter.toInstant());
            }
            if ((notBefore = x509Certificate.getNotBefore()) != null) {
                dataBean.setNotBefore(notBefore.toInstant());
            }
            if ((issuer = x509Certificate.getIssuerX500Principal()) != null) {
                dataBean.setIssuer(issuer.getName());
            }
            if ((subject = x509Certificate.getSubjectX500Principal()) != null) {
                dataBean.setSubject(subject.getName());
            }
            if ((serialNumber = x509Certificate.getSerialNumber()) != null) {
                dataBean.setSerialNumber(serialNumber);
            }
            if ((signatureAlgorithmName = x509Certificate.getSigAlgName()) != null) {
                dataBean.setSignatureAlgorithm(signatureAlgorithmName);
            }
            return dataBean;
        }
        throw new UnsupportedOperationException("Unsupported certificate type: " + certificate.getType());
    }
}

