/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.access.ec.bc;

import java.math.BigInteger;
import net.sf.mmm.crypto.asymmetric.access.ec.bc.AsymmetricAccessEcBc;
import net.sf.mmm.crypto.asymmetric.access.ec.bc.CryptoEllipticCurveBc;
import net.sf.mmm.crypto.asymmetric.crypt.ec.AsymmetricCryptorConfigEcIes;
import net.sf.mmm.crypto.asymmetric.sign.SignatureConfig;
import net.sf.mmm.crypto.asymmetric.sign.ec.bc.SignatureEcBc;
import net.sf.mmm.crypto.asymmetric.sign.ec.bc.SignatureEcBcPlain;
import net.sf.mmm.crypto.asymmetric.sign.ec.bc.SignatureEcBcWithRecoveryId;
import net.sf.mmm.crypto.asymmetric.sign.ec.bc.SignatureFactoryEcBc;
import net.sf.mmm.crypto.asymmetric.sign.ec.bc.SignatureFactoryEcBcPlain;
import net.sf.mmm.crypto.asymmetric.sign.ec.bc.SignatureFactoryEcBcWithRecoveryId;
import net.sf.mmm.crypto.hash.HashConfig;
import net.sf.mmm.crypto.random.RandomFactory;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Curve;

public class Secp256k1<S extends SignatureEcBc>
extends AsymmetricAccessEcBc<S> {
    public static final String CURVE_NAME = "secp256k1";
    public static final CryptoEllipticCurveBc CURVE = new CryptoEllipticCurveBc("secp256k1"){

        @Override
        protected BigInteger determineCurveQ() {
            SecP256K1Curve curve = (SecP256K1Curve)this.getEcParameters().getCurve();
            return curve.getQ();
        }
    };

    public Secp256k1(SignatureConfig<S> signatureConfig, AsymmetricCryptorConfigEcIes<BCECPrivateKey, BCECPublicKey> cryptorConfig, RandomFactory randomFactory) {
        super(CURVE.getEcParameters(), signatureConfig, cryptorConfig, randomFactory);
    }

    public Secp256k1(SignatureFactoryEcBc<S> signatureFactory, HashConfig hashConfig, RandomFactory randomFactory) {
        super(CURVE.getEcParameters(), signatureFactory, hashConfig, randomFactory);
    }

    public static Secp256k1<SignatureEcBcPlain> ofPlain(String hashAlgorithm) {
        return Secp256k1.ofPlain(new HashConfig(hashAlgorithm));
    }

    public static Secp256k1<SignatureEcBcPlain> ofPlain(HashConfig hashConfig) {
        return Secp256k1.of(new SignatureFactoryEcBcPlain(CURVE), hashConfig, null);
    }

    public static Secp256k1<SignatureEcBcWithRecoveryId> ofRecoveryId(String hashAlgorithm) {
        return Secp256k1.ofRecoveryId(new HashConfig(hashAlgorithm));
    }

    public static Secp256k1<SignatureEcBcWithRecoveryId> ofRecoveryId(HashConfig hashConfig) {
        return Secp256k1.of(new SignatureFactoryEcBcWithRecoveryId(CURVE), hashConfig, null);
    }

    public static <S extends SignatureEcBc> Secp256k1<S> of(SignatureFactoryEcBc<S> signatureFactory, HashConfig hashConfig, RandomFactory randomFactory) {
        return new Secp256k1<S>(signatureFactory, hashConfig, randomFactory);
    }
}

