/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.access.ec.bc;

import java.math.BigInteger;
import net.sf.mmm.crypto.asymmetric.access.ec.bc.AsymmetricAccessEcBc;
import net.sf.mmm.crypto.asymmetric.access.ec.bc.CryptoEllipticCurveBc;
import net.sf.mmm.crypto.asymmetric.crypt.ec.AsymmetricCryptorConfigEcIes;
import net.sf.mmm.crypto.asymmetric.sign.SignatureConfig;
import net.sf.mmm.crypto.asymmetric.sign.ec.bc.SignatureEcBc;
import net.sf.mmm.crypto.asymmetric.sign.ec.bc.SignatureEcBcPlain;
import net.sf.mmm.crypto.asymmetric.sign.ec.bc.SignatureEcBcWithRecoveryId;
import net.sf.mmm.crypto.asymmetric.sign.ec.bc.SignatureFactoryEcBc;
import net.sf.mmm.crypto.asymmetric.sign.ec.bc.SignatureFactoryEcBcPlain;
import net.sf.mmm.crypto.asymmetric.sign.ec.bc.SignatureFactoryEcBcWithRecoveryId;
import net.sf.mmm.crypto.hash.HashConfig;
import net.sf.mmm.crypto.random.RandomFactory;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;

public class Curve25519<S extends SignatureEcBc>
extends AsymmetricAccessEcBc<S> {
    public static final String CURVE_NAME = "curve25519";
    public static final CryptoEllipticCurveBc CURVE = new CryptoEllipticCurveBc("curve25519"){

        @Override
        protected BigInteger determineCurveQ() {
            org.bouncycastle.math.ec.custom.djb.Curve25519 curve = (org.bouncycastle.math.ec.custom.djb.Curve25519)this.getEcParameters().getCurve();
            return curve.getQ();
        }
    };

    public Curve25519(SignatureConfig<S> signatureConfig, AsymmetricCryptorConfigEcIes<BCECPrivateKey, BCECPublicKey> cryptorConfig, RandomFactory randomFactory) {
        super(CURVE.getEcParameters(), signatureConfig, cryptorConfig, randomFactory);
    }

    public Curve25519(SignatureFactoryEcBc<S> signatureFactory, HashConfig hashConfig, RandomFactory randomFactory) {
        super(CURVE.getEcParameters(), signatureFactory, hashConfig, randomFactory);
    }

    public static Curve25519<SignatureEcBcPlain> ofPlain(String hashAlgorithm) {
        return Curve25519.ofPlain(new HashConfig(hashAlgorithm));
    }

    public static Curve25519<SignatureEcBcPlain> ofPlain(HashConfig hashConfig) {
        return Curve25519.of(new SignatureFactoryEcBcPlain(CURVE), hashConfig, null);
    }

    public static Curve25519<SignatureEcBcWithRecoveryId> ofRecoveryId(String hashAlgorithm) {
        return Curve25519.ofRecoveryId(new HashConfig(hashAlgorithm));
    }

    public static Curve25519<SignatureEcBcWithRecoveryId> ofRecoveryId(HashConfig hashConfig) {
        return Curve25519.of(new SignatureFactoryEcBcWithRecoveryId(CURVE), hashConfig, null);
    }

    public static <S extends SignatureEcBc> Curve25519<S> of(SignatureFactoryEcBc<S> signatureFactory, HashConfig hashConfig, RandomFactory randomFactory) {
        return new Curve25519<S>(signatureFactory, hashConfig, randomFactory);
    }
}

