/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.access.ec.bc;

import java.math.BigInteger;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.jce.spec.ECParameterSpec;

public abstract class CryptoEllipticCurveBc {
    private final String curveName;
    private ECParameterSpec ecParameters;
    private BigInteger q;
    private BigInteger halfN;

    CryptoEllipticCurveBc(String curveName) {
        this.curveName = curveName;
    }

    public String getCurveName() {
        return this.curveName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ECParameterSpec getEcParameters() {
        if (this.ecParameters != null) return this.ecParameters;
        Class<CryptoEllipticCurveBc> clazz = CryptoEllipticCurveBc.class;
        synchronized (CryptoEllipticCurveBc.class) {
            if (this.ecParameters != null) return this.ecParameters;
            X9ECParameters ecP = CustomNamedCurves.getByName((String)this.curveName);
            this.ecParameters = new ECParameterSpec(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.ecParameters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BigInteger getQ() {
        if (this.q != null) return this.q;
        Class<CryptoEllipticCurveBc> clazz = CryptoEllipticCurveBc.class;
        synchronized (CryptoEllipticCurveBc.class) {
            if (this.q != null) return this.q;
            this.q = this.determineCurveQ();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.q;
        }
    }

    protected abstract BigInteger determineCurveQ();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BigInteger getHalfN() {
        if (this.halfN != null) return this.halfN;
        Class<CryptoEllipticCurveBc> clazz = CryptoEllipticCurveBc.class;
        synchronized (CryptoEllipticCurveBc.class) {
            if (this.halfN != null) return this.halfN;
            this.halfN = this.getEcParameters().getN().shiftRight(1);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.halfN;
        }
    }

    public int getBitLength() {
        return this.getEcParameters().getCurve().getOrder().bitLength();
    }

    public int getByteLength() {
        return CryptoEllipticCurveBc.getByteLength(this.getEcParameters());
    }

    public static int getByteLength(ECParameterSpec ecParameters) {
        return (ecParameters.getCurve().getOrder().bitLength() + 7) / 8;
    }
}

