/*
 * Decompiled with CFR 0.152.
 */
package loggersoft.kotlin.utils.graph;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import loggersoft.kotlin.utils.graph.AbstractEdge;
import loggersoft.kotlin.utils.graph.DynamicEdge;
import loggersoft.kotlin.utils.graph.Edge;
import loggersoft.kotlin.utils.graph.ExternalEdge;
import loggersoft.kotlin.utils.graph.Graph;
import loggersoft.kotlin.utils.graph.MutableGraph;
import loggersoft.kotlin.utils.graph.MutableGraphImpl;
import loggersoft.kotlin.utils.graph.StaticEdge;
import loggersoft.kotlin.utils.graph.Vertex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0010\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004:\u0001;B3\b\u0010\u0012*\u0010\u0005\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00070\u0006\"\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\bB\u001b\b\u0014\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0002\u0010\nJ\u0014\u0010#\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J\u0014\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010%H\u0016J\u001d\u0010&\u001a\u00020'2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007H\u0082\bJ)\u0010)\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00072\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007H\u0082\bJ\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\"\u0010-\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001d2\u0006\u0010.\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010/J7\u00100\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00070\u00192\u0006\u00101\u001a\u00028\u00002\u0006\u00102\u001a\u00028\u00002\u0006\u00103\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u00104J&\u00105\u001a\u001206R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010.\u001a\u00028\u0000H\u0084\b\u00a2\u0006\u0002\u00107J\b\u00108\u001a\u00020\fH\u0016J(\u00109\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00072\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007H\u0004J&\u0010:\u001a\u001206R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010.\u001a\u00028\u0000H\u0084\b\u00a2\u0006\u0002\u00107R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R$\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR&\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001d0\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001bR,\u0010\u001f\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001d0 X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006<"}, d2={"Lloggersoft/kotlin/utils/graph/GraphImpl;", "V", "", "E", "Lloggersoft/kotlin/utils/graph/Graph;", "edges", "", "Lloggersoft/kotlin/utils/graph/Edge;", "([Lloggersoft/kotlin/utils/graph/Edge;)V", "graph", "(Lloggersoft/kotlin/utils/graph/Graph;)V", "<set-?>", "", "dynamicEdgesCount", "getDynamicEdgesCount", "()I", "setDynamicEdgesCount", "(I)V", "edgesCount", "getEdgesCount", "setEdgesCount", "orientedEdgesCount", "getOrientedEdgesCount", "setOrientedEdgesCount", "values", "", "getValues", "()Ljava/util/Collection;", "vertexes", "Lloggersoft/kotlin/utils/graph/Vertex;", "getVertexes", "vertexesMap", "", "getVertexesMap", "()Ljava/util/Map;", "clone", "cloneAsMutable", "Lloggersoft/kotlin/utils/graph/MutableGraph;", "cloneEdge", "", "edge", "copyEdge", "equals", "", "other", "get", "value", "(Ljava/lang/Object;)Lloggersoft/kotlin/utils/graph/Vertex;", "getEdges", "startFrom", "endWith", "limit", "(Ljava/lang/Object;Ljava/lang/Object;I)Ljava/util/Collection;", "getVertex", "Lloggersoft/kotlin/utils/graph/GraphImpl$VertexImpl;", "(Ljava/lang/Object;)Lloggersoft/kotlin/utils/graph/GraphImpl$VertexImpl;", "hashCode", "insertEdge", "insertVertex", "VertexImpl", "kotlin-utils"})
public class GraphImpl<V, E>
implements Graph<V, E> {
    private int edgesCount;
    private int orientedEdgesCount;
    private int dynamicEdgesCount;
    @NotNull
    private final Map<V, Vertex<V, E>> vertexesMap;

    public boolean equals(@Nullable Object other) {
        return other != null && (this == other || other instanceof GraphImpl && Intrinsics.areEqual(this.vertexesMap, ((GraphImpl)other).vertexesMap));
    }

    public int hashCode() {
        return ((Object)this.vertexesMap).hashCode();
    }

    @Override
    @NotNull
    public Graph<V, E> clone() {
        return new GraphImpl<V, E>(this);
    }

    @Override
    @NotNull
    public MutableGraph<V, E> cloneAsMutable() {
        return new MutableGraphImpl(this);
    }

    @Override
    @NotNull
    public Collection<V> getValues() {
        return this.vertexesMap.keySet();
    }

    @Override
    @NotNull
    public Collection<Vertex<V, E>> getVertexes() {
        return this.vertexesMap.values();
    }

    @Override
    public int getEdgesCount() {
        return this.edgesCount;
    }

    protected void setEdgesCount(int n) {
        this.edgesCount = n;
    }

    @Override
    public int getOrientedEdgesCount() {
        return this.orientedEdgesCount;
    }

    protected void setOrientedEdgesCount(int n) {
        this.orientedEdgesCount = n;
    }

    @Override
    public int getDynamicEdgesCount() {
        return this.dynamicEdgesCount;
    }

    protected void setDynamicEdgesCount(int n) {
        this.dynamicEdgesCount = n;
    }

    @Override
    @NotNull
    public Vertex<V, E> get(@NotNull V value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        Vertex<V, E> vertex = this.vertexesMap.get(value);
        if (vertex == null) {
            throw (Throwable)new NoSuchElementException();
        }
        return vertex;
    }

    @Override
    @NotNull
    public Collection<Edge<V, E>> getEdges(@NotNull V startFrom, @NotNull V endWith, int limit) {
        Intrinsics.checkParameterIsNotNull(startFrom, (String)"startFrom");
        Intrinsics.checkParameterIsNotNull(endWith, (String)"endWith");
        GraphImpl this_$iv = this;
        boolean $i$f$getVertex = false;
        VertexImpl vertexImpl = (VertexImpl)this_$iv.vertexesMap.get(startFrom);
        if (vertexImpl == null) {
            throw (Throwable)new NoSuchElementException();
        }
        VertexImpl startVertex = vertexImpl;
        GraphImpl this_$iv2 = this;
        boolean $i$f$getVertex2 = false;
        VertexImpl vertexImpl2 = (VertexImpl)this_$iv2.vertexesMap.get(endWith);
        if (vertexImpl2 == null) {
            throw (Throwable)new NoSuchElementException();
        }
        VertexImpl endVertex = vertexImpl2;
        List edges2 = SequencesKt.toList((Sequence)SequencesKt.take((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)startVertex.getStartsIn()), (Function1)new Function1<Edge<V, ? extends E>, Boolean>(endVertex){
            final /* synthetic */ VertexImpl $endVertex;

            public final boolean invoke(@NotNull Edge<V, ? extends E> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return this.$endVertex.getEndsIn().contains(it);
            }
            {
                this.$endVertex = vertexImpl;
                super(1);
            }
        }), (int)(limit > 0 ? limit : this.getEdgesCount())));
        return this.isOriented() || limit > 0 && edges2.size() >= limit ? (Collection)edges2 : (Collection)CollectionsKt.plus((Collection)edges2, (Sequence)SequencesKt.take((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)startVertex.getEndsIn()), (Function1)new Function1<Edge<V, ? extends E>, Boolean>(endVertex){
            final /* synthetic */ VertexImpl $endVertex;

            public final boolean invoke(@NotNull Edge<V, ? extends E> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return !it.isOriented() && this.$endVertex.getStartsIn().contains(it);
            }
            {
                this.$endVertex = vertexImpl;
                super(1);
            }
        }), (int)(limit > 0 ? limit - edges2.size() : this.getEdgesCount())));
    }

    @NotNull
    protected final VertexImpl getVertex(@NotNull V value) {
        int $i$f$getVertex = 0;
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        VertexImpl vertexImpl = (VertexImpl)this.vertexesMap.get(value);
        if (vertexImpl == null) {
            throw (Throwable)new NoSuchElementException();
        }
        return vertexImpl;
    }

    @NotNull
    protected final VertexImpl insertVertex(@NotNull V value) {
        Object object;
        int $i$f$insertVertex = 0;
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        Map $this$getOrPut$iv = this.vertexesMap;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(value);
        if (value$iv == null) {
            boolean bl = false;
            VertexImpl answer$iv = new VertexImpl(value);
            $this$getOrPut$iv.put(value, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (VertexImpl)object;
    }

    @NotNull
    protected final Edge<V, E> insertEdge(@NotNull Edge<V, ? extends E> edge) {
        Object object;
        VertexImpl answer$iv$iv;
        boolean bl;
        GraphImpl this_$iv;
        Intrinsics.checkParameterIsNotNull(edge, (String)"edge");
        GraphImpl graphImpl = this;
        V value$iv = edge.getStartFrom();
        boolean $i$f$insertVertex = false;
        Map $this$getOrPut$iv$iv = this_$iv.vertexesMap;
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(value$iv);
        if (value$iv$iv == null) {
            bl = false;
            answer$iv$iv = this_$iv.new VertexImpl(value$iv);
            $this$getOrPut$iv$iv.put(value$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        if (((VertexImpl)object).getStartsIn().add(edge)) {
            Object object2;
            this_$iv = this;
            value$iv = edge.getEndWith();
            $i$f$insertVertex = false;
            $this$getOrPut$iv$iv = this_$iv.vertexesMap;
            $i$f$getOrPut = false;
            value$iv$iv = $this$getOrPut$iv$iv.get(value$iv);
            if (value$iv$iv == null) {
                bl = false;
                answer$iv$iv = this_$iv.new VertexImpl(value$iv);
                $this$getOrPut$iv$iv.put(value$iv, answer$iv$iv);
                object2 = answer$iv$iv;
            } else {
                object2 = value$iv$iv;
            }
            ((VertexImpl)object2).getEndsIn().add(edge);
            GraphImpl graphImpl2 = this;
            int n = graphImpl2.getEdgesCount();
            graphImpl2.setEdgesCount(n + 1);
            if (edge.isOriented()) {
                GraphImpl graphImpl3 = this;
                n = graphImpl3.getOrientedEdgesCount();
                graphImpl3.setOrientedEdgesCount(n + 1);
            }
            if (edge.isDynamicWeight()) {
                GraphImpl graphImpl4 = this;
                n = graphImpl4.getDynamicEdgesCount();
                graphImpl4.setDynamicEdgesCount(n + 1);
            }
        }
        return edge;
    }

    @NotNull
    protected final Map<V, Vertex<V, E>> getVertexesMap() {
        return this.vertexesMap;
    }

    private final void cloneEdge(Edge<V, ? extends E> edge) {
        Edge edge2;
        int $i$f$cloneEdge = 0;
        GraphImpl graphImpl = this;
        GraphImpl graphImpl2 = this;
        boolean $i$f$copyEdge = false;
        if (edge instanceof ExternalEdge || edge instanceof StaticEdge) {
            edge2 = edge;
        } else if (edge.getValue() instanceof AbstractEdge) {
            E e = edge.getValue();
            if (e == null) {
                throw new TypeCastException("null cannot be cast to non-null type loggersoft.kotlin.utils.graph.AbstractEdge");
            }
            edge2 = new ExternalEdge<V, AbstractEdge>(edge.getStartFrom(), edge.getEndWith(), (AbstractEdge)e);
        } else if (edge.isDynamicWeight()) {
            DynamicEdge<V, E> dynamicEdge = new DynamicEdge<V, E>(edge.getStartFrom(), edge.getEndWith(), edge.getValue(), edge.isOriented());
            boolean bl = false;
            boolean bl2 = false;
            DynamicEdge<V, E> $this$apply$iv = dynamicEdge;
            boolean bl3 = false;
            $this$apply$iv.setHasWeight(edge.getHasWeight());
            $this$apply$iv.setWeight(edge.getWeight());
            edge2 = dynamicEdge;
        } else {
            edge2 = edge;
        }
        Edge edge3 = edge2;
        graphImpl2.insertEdge(edge3);
    }

    private final Edge<V, E> copyEdge(Edge<V, ? extends E> edge) {
        Edge edge2;
        int $i$f$copyEdge = 0;
        if (edge instanceof ExternalEdge || edge instanceof StaticEdge) {
            edge2 = edge;
        } else if (edge.getValue() instanceof AbstractEdge) {
            E e = edge.getValue();
            if (e == null) {
                throw new TypeCastException("null cannot be cast to non-null type loggersoft.kotlin.utils.graph.AbstractEdge");
            }
            edge2 = new ExternalEdge<V, AbstractEdge>(edge.getStartFrom(), edge.getEndWith(), (AbstractEdge)e);
        } else if (edge.isDynamicWeight()) {
            DynamicEdge<V, E> dynamicEdge = new DynamicEdge<V, E>(edge.getStartFrom(), edge.getEndWith(), edge.getValue(), edge.isOriented());
            boolean bl = false;
            boolean bl2 = false;
            DynamicEdge<V, E> $this$apply = dynamicEdge;
            boolean bl3 = false;
            $this$apply.setHasWeight(edge.getHasWeight());
            $this$apply.setWeight(edge.getWeight());
            edge2 = dynamicEdge;
        } else {
            edge2 = edge;
        }
        return edge2;
    }

    public GraphImpl(Edge<V, ? extends E> ... edges2) {
        Map map;
        Intrinsics.checkParameterIsNotNull(edges2, (String)"edges");
        GraphImpl graphImpl = this;
        boolean bl = false;
        graphImpl.vertexesMap = map = (Map)new LinkedHashMap();
        for (Edge<V, ? extends E> edge : edges2) {
            this.insertEdge(edge);
        }
    }

    protected GraphImpl(@NotNull Graph<V, E> graph) {
        Map map;
        Intrinsics.checkParameterIsNotNull(graph, (String)"graph");
        GraphImpl graphImpl = this;
        boolean bl = false;
        graphImpl.vertexesMap = map = (Map)new LinkedHashMap();
        for (Vertex<V, E> vertex : graph.getVertexes()) {
            Edge edge;
            boolean bl2;
            DynamicEdge $this$apply$iv$iv;
            boolean bl3;
            boolean bl4;
            DynamicEdge dynamicEdge;
            boolean $i$f$copyEdge;
            GraphImpl graphImpl2;
            boolean $i$f$cloneEdge;
            GraphImpl this_$iv;
            Edge p1;
            Iterable $this$forEach$iv;
            Object object;
            Iterable this_$iv2;
            GraphImpl graphImpl3 = this;
            V value$iv = vertex.getValue();
            boolean $i$f$insertVertex = false;
            Map $this$getOrPut$iv$iv = ((GraphImpl)((Object)this_$iv2)).vertexesMap;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv = $this$getOrPut$iv$iv.get(value$iv);
            if (value$iv$iv == null) {
                boolean bl5 = false;
                VertexImpl answer$iv$iv = (GraphImpl)((Object)this_$iv2).new VertexImpl(value$iv);
                $this$getOrPut$iv$iv.put(value$iv, answer$iv$iv);
                object = answer$iv$iv;
            } else {
                object = value$iv$iv;
            }
            VertexImpl cfr_ignored_0 = (VertexImpl)object;
            this_$iv2 = vertex.getStartsIn();
            GraphImpl graphImpl4 = this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Edge edge2;
                p1 = (Edge)element$iv;
                boolean bl6 = false;
                this_$iv = graphImpl4;
                $i$f$cloneEdge = false;
                GraphImpl graphImpl5 = this_$iv;
                graphImpl2 = this_$iv;
                $i$f$copyEdge = false;
                if (p1 instanceof ExternalEdge || p1 instanceof StaticEdge) {
                    edge2 = p1;
                } else if (p1.getValue() instanceof AbstractEdge) {
                    Object e = p1.getValue();
                    if (e == null) {
                        throw new TypeCastException("null cannot be cast to non-null type loggersoft.kotlin.utils.graph.AbstractEdge");
                    }
                    edge2 = new ExternalEdge(p1.getStartFrom(), p1.getEndWith(), (AbstractEdge)e);
                } else if (p1.isDynamicWeight()) {
                    dynamicEdge = new DynamicEdge(p1.getStartFrom(), p1.getEndWith(), p1.getValue(), p1.isOriented());
                    bl4 = false;
                    bl3 = false;
                    $this$apply$iv$iv = dynamicEdge;
                    bl2 = false;
                    $this$apply$iv$iv.setHasWeight(p1.getHasWeight());
                    $this$apply$iv$iv.setWeight(p1.getWeight());
                    edge2 = dynamicEdge;
                } else {
                    edge2 = p1;
                }
                edge = edge2;
                graphImpl2.insertEdge(edge);
            }
            $this$forEach$iv = vertex.getEndsIn();
            graphImpl4 = this;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Edge edge3;
                p1 = (Edge)element$iv;
                boolean bl7 = false;
                this_$iv = graphImpl4;
                $i$f$cloneEdge = false;
                GraphImpl this_$iv$iv = this_$iv;
                graphImpl2 = this_$iv;
                $i$f$copyEdge = false;
                if (p1 instanceof ExternalEdge || p1 instanceof StaticEdge) {
                    edge3 = p1;
                } else if (p1.getValue() instanceof AbstractEdge) {
                    Object e = p1.getValue();
                    if (e == null) {
                        throw new TypeCastException("null cannot be cast to non-null type loggersoft.kotlin.utils.graph.AbstractEdge");
                    }
                    edge3 = new ExternalEdge(p1.getStartFrom(), p1.getEndWith(), (AbstractEdge)e);
                } else if (p1.isDynamicWeight()) {
                    dynamicEdge = new DynamicEdge(p1.getStartFrom(), p1.getEndWith(), p1.getValue(), p1.isOriented());
                    bl4 = false;
                    bl3 = false;
                    $this$apply$iv$iv = dynamicEdge;
                    bl2 = false;
                    $this$apply$iv$iv.setHasWeight(p1.getHasWeight());
                    $this$apply$iv$iv.setWeight(p1.getWeight());
                    edge3 = dynamicEdge;
                } else {
                    edge3 = p1;
                }
                edge = edge3;
                graphImpl2.insertEdge(edge);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return Graph.DefaultImpls.isEmpty(this);
    }

    @Override
    public boolean isOriented() {
        return Graph.DefaultImpls.isOriented(this);
    }

    @Override
    public boolean contains(@NotNull V value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        return Graph.DefaultImpls.contains(this, value);
    }

    @Override
    public boolean contains(@NotNull Edge<V, ? extends E> edge) {
        Intrinsics.checkParameterIsNotNull(edge, (String)"edge");
        return Graph.DefaultImpls.contains(this, edge);
    }

    @Override
    public boolean isConnected(@NotNull V startFrom, @NotNull V endWith) {
        Intrinsics.checkParameterIsNotNull(startFrom, (String)"startFrom");
        Intrinsics.checkParameterIsNotNull(endWith, (String)"endWith");
        return Graph.DefaultImpls.isConnected(this, startFrom, endWith);
    }

    public static final /* synthetic */ Edge access$copyEdge(GraphImpl $this, Edge edge) {
        return $this.copyEdge(edge);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0084\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0015\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015R&\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR&\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0016\u0010\u0002\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lloggersoft/kotlin/utils/graph/GraphImpl$VertexImpl;", "Lloggersoft/kotlin/utils/graph/Vertex;", "value", "(Lloggersoft/kotlin/utils/graph/GraphImpl;Ljava/lang/Object;)V", "endsIn", "", "Lloggersoft/kotlin/utils/graph/Edge;", "getEndsIn", "()Ljava/util/Set;", "startsIn", "getStartsIn", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "equals", "", "other", "", "hashCode", "", "isConnectedWith", "(Ljava/lang/Object;)Z", "kotlin-utils"})
    protected final class VertexImpl
    implements Vertex<V, E> {
        @NotNull
        private final Set<Edge<V, E>> startsIn;
        @NotNull
        private final Set<Edge<V, E>> endsIn;
        @NotNull
        private final V value;

        public boolean equals(@Nullable Object other) {
            return other != null && (this == other || other instanceof Vertex && Intrinsics.areEqual(this.getValue(), ((Vertex)other).getValue()) && Intrinsics.areEqual((Object)this.getStartsIn(), ((Vertex)other).getStartsIn()) && Intrinsics.areEqual((Object)this.getEndsIn(), ((Vertex)other).getEndsIn()));
        }

        public int hashCode() {
            return Objects.hash(this.getStartsIn(), this.getEndsIn(), this.getValue());
        }

        @Override
        @NotNull
        public Set<Edge<V, E>> getStartsIn() {
            return this.startsIn;
        }

        @Override
        @NotNull
        public Set<Edge<V, E>> getEndsIn() {
            return this.endsIn;
        }

        @Override
        public boolean isConnectedWith(@NotNull V value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return GraphImpl.this.isConnected(this.getValue(), value);
        }

        @Override
        @NotNull
        public V getValue() {
            return this.value;
        }

        public VertexImpl(V value) {
            Set set;
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            this.value = value;
            VertexImpl vertexImpl = this;
            boolean bl = false;
            vertexImpl.startsIn = set = (Set)new LinkedHashSet();
            vertexImpl = this;
            bl = false;
            vertexImpl.endsIn = set = (Set)new LinkedHashSet();
        }

        @Override
        public boolean contains(@NotNull Edge<?, ?> edge) {
            Intrinsics.checkParameterIsNotNull(edge, (String)"edge");
            return Vertex.DefaultImpls.contains(this, edge);
        }
    }
}

