/*
 * Decompiled with CFR 0.152.
 */
package loggersoft.kotlin.utils.graph;

import java.util.Collection;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import loggersoft.kotlin.utils.graph.Edge;
import loggersoft.kotlin.utils.graph.MutableGraph;
import loggersoft.kotlin.utils.graph.Vertex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001a\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0004J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H&J\u0014\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001aH&J\u0016\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001dJ\u001d\u0010\u001b\u001a\u00020\f2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001fH\u0096\u0002J\"\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00162\u0006\u0010\u001c\u001a\u00028\u0000H\u00a6\u0002\u00a2\u0006\u0002\u0010!J9\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001f0\u00122\u0006\u0010#\u001a\u00028\u00002\u0006\u0010$\u001a\u00028\u00002\b\b\u0002\u0010%\u001a\u00020\u0006H&\u00a2\u0006\u0002\u0010&J\u001d\u0010'\u001a\u00020\f2\u0006\u0010#\u001a\u00028\u00002\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010(R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0014\u0010\u000e\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\rR\u0012\u0010\u000f\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00160\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014\u00a8\u0006)"}, d2={"Lloggersoft/kotlin/utils/graph/Graph;", "V", "", "E", "", "dynamicEdgesCount", "", "getDynamicEdgesCount", "()I", "edgesCount", "getEdgesCount", "isEmpty", "", "()Z", "isOriented", "orientedEdgesCount", "getOrientedEdgesCount", "values", "", "getValues", "()Ljava/util/Collection;", "vertexes", "Lloggersoft/kotlin/utils/graph/Vertex;", "getVertexes", "clone", "cloneAsMutable", "Lloggersoft/kotlin/utils/graph/MutableGraph;", "contains", "value", "(Ljava/lang/Object;)Z", "edge", "Lloggersoft/kotlin/utils/graph/Edge;", "get", "(Ljava/lang/Object;)Lloggersoft/kotlin/utils/graph/Vertex;", "getEdges", "startFrom", "endWith", "limit", "(Ljava/lang/Object;Ljava/lang/Object;I)Ljava/util/Collection;", "isConnected", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "kotlin-utils"})
public interface Graph<V, E>
extends Cloneable {
    @NotNull
    public Collection<V> getValues();

    @NotNull
    public Collection<Vertex<V, E>> getVertexes();

    public boolean isEmpty();

    public boolean isOriented();

    public int getEdgesCount();

    public int getOrientedEdgesCount();

    public int getDynamicEdgesCount();

    @NotNull
    public Graph<V, E> clone();

    @NotNull
    public MutableGraph<V, E> cloneAsMutable();

    public boolean contains(@NotNull V var1);

    public boolean contains(@NotNull Edge<V, ? extends E> var1);

    @NotNull
    public Vertex<V, E> get(@NotNull V var1);

    @NotNull
    public Collection<Edge<V, E>> getEdges(@NotNull V var1, @NotNull V var2, int var3);

    public boolean isConnected(@NotNull V var1, @NotNull V var2);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static <V, E> boolean isEmpty(Graph<V, E> $this) {
            return $this.getValues().isEmpty();
        }

        public static <V, E> boolean isOriented(Graph<V, E> $this) {
            return $this.getOrientedEdgesCount() == $this.getEdgesCount();
        }

        public static <V, E> boolean contains(Graph<V, E> $this, @NotNull V value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return $this.getValues().contains(value);
        }

        public static <V, E> boolean contains(Graph<V, E> $this, @NotNull Edge<V, ? extends E> edge) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull(edge, (String)"edge");
            try {
                bl = $this.get(edge.getStartFrom()).getStartsIn().contains(edge) && $this.get(edge.getEndWith()).getEndsIn().contains(edge);
            }
            catch (NoSuchElementException _) {
                bl = false;
            }
            return bl;
        }

        public static /* synthetic */ Collection getEdges$default(Graph graph, Object object, Object object2, int n, int n2, Object object3) {
            if (object3 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getEdges");
            }
            if ((n2 & 4) != 0) {
                n = -1;
            }
            return graph.getEdges(object, object2, n);
        }

        public static <V, E> boolean isConnected(Graph<V, E> $this, @NotNull V startFrom, @NotNull V endWith) {
            Intrinsics.checkParameterIsNotNull(startFrom, (String)"startFrom");
            Intrinsics.checkParameterIsNotNull(endWith, (String)"endWith");
            Collection<Edge<V, E>> collection = $this.getEdges(startFrom, endWith, 1);
            boolean bl = false;
            return !collection.isEmpty();
        }
    }
}

