/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juffrou.xml;

import java.io.InputStream;
import net.sf.juffrou.xml.JuffrouXml;
import net.sf.juffrou.xml.internal.config.JuffrouSpringConfigReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.util.ObjectUtils;

public class JuffrouXmlSpring
extends JuffrouXml
implements ApplicationContextAware,
InitializingBean {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ApplicationContext applicationContext;
    private Resource[] mappingLocations;

    public Resource[] getMappingLocations() {
        return this.mappingLocations;
    }

    public void setMappingLocations(Resource[] mappingLocations) {
        this.mappingLocations = mappingLocations;
    }

    public void afterPropertiesSet() throws Exception {
        if (!ObjectUtils.isEmpty((Object[])this.mappingLocations)) {
            JuffrouSpringConfigReader configReader = new JuffrouSpringConfigReader(this.applicationContext);
            for (Resource mappingLocation : this.mappingLocations) {
                try {
                    InputStream inputStream = mappingLocation.getInputStream();
                    this.readConfigFile(configReader, inputStream);
                    inputStream.close();
                }
                catch (RuntimeException e) {
                    if (!this.logger.isErrorEnabled()) continue;
                    this.logger.error((Object)("Cannot read configuration file " + mappingLocation.toString()), (Throwable)e);
                }
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"No mapping location defined. Using default configuration for JuffrouXml.");
        }
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.applicationContext = context;
    }
}

