/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juffrou.reflect;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Currency;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import net.sf.juffrou.reflect.BeanWrapperContext;
import net.sf.juffrou.reflect.JuffrouBeanWrapper;
import net.sf.juffrou.reflect.JuffrouPropertyDescriptor;
import net.sf.juffrou.reflect.JuffrouTypeConverterDelegate;
import net.sf.juffrou.reflect.error.InvalidPropertyException;
import net.sf.juffrou.reflect.internal.BeanFieldHandler;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.propertyeditors.ByteArrayPropertyEditor;
import org.springframework.beans.propertyeditors.CharArrayPropertyEditor;
import org.springframework.beans.propertyeditors.CharacterEditor;
import org.springframework.beans.propertyeditors.CharsetEditor;
import org.springframework.beans.propertyeditors.ClassArrayEditor;
import org.springframework.beans.propertyeditors.ClassEditor;
import org.springframework.beans.propertyeditors.CurrencyEditor;
import org.springframework.beans.propertyeditors.CustomBooleanEditor;
import org.springframework.beans.propertyeditors.CustomCollectionEditor;
import org.springframework.beans.propertyeditors.CustomMapEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.beans.propertyeditors.FileEditor;
import org.springframework.beans.propertyeditors.InputSourceEditor;
import org.springframework.beans.propertyeditors.InputStreamEditor;
import org.springframework.beans.propertyeditors.LocaleEditor;
import org.springframework.beans.propertyeditors.PatternEditor;
import org.springframework.beans.propertyeditors.PropertiesEditor;
import org.springframework.beans.propertyeditors.StringArrayPropertyEditor;
import org.springframework.beans.propertyeditors.TimeZoneEditor;
import org.springframework.beans.propertyeditors.URIEditor;
import org.springframework.beans.propertyeditors.URLEditor;
import org.springframework.beans.propertyeditors.UUIDEditor;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourceArrayPropertyEditor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.xml.sax.InputSource;

public class JuffrouSpringBeanWrapper
extends JuffrouBeanWrapper
implements BeanWrapper {
    private Map<Class<?>, PropertyEditor> customEditors;
    private Map<String, CustomEditorHolder> customEditorsForPath;
    private Map<Class<?>, PropertyEditor> customEditorCache;
    private Set<PropertyEditor> sharedEditors;
    private final boolean defaultEditorsActive = false;
    private boolean configValueEditorsActive = false;
    private Map<Class<?>, PropertyEditor> overriddenDefaultEditors;
    private Map<Class<?>, PropertyEditor> defaultEditors;
    private ConversionService conversionService;
    private JuffrouTypeConverterDelegate typeConverterDelegate;
    private boolean extractOldValueForEditor;

    public JuffrouSpringBeanWrapper(BeanWrapperContext context, JuffrouBeanWrapper parentBeanWrapper, String parentBeanProperty) {
        super(context, parentBeanWrapper, parentBeanProperty);
        this.typeConverterDelegate = new JuffrouTypeConverterDelegate(this);
    }

    public JuffrouSpringBeanWrapper(BeanWrapperContext context, Object instance) {
        super(context, instance);
        this.typeConverterDelegate = new JuffrouTypeConverterDelegate(this, instance);
    }

    public JuffrouSpringBeanWrapper(BeanWrapperContext context) {
        super(context);
        this.typeConverterDelegate = new JuffrouTypeConverterDelegate(this);
    }

    public JuffrouSpringBeanWrapper(Class<?> clazz) {
        super(clazz);
        this.typeConverterDelegate = new JuffrouTypeConverterDelegate(this);
    }

    public JuffrouSpringBeanWrapper(Object instance) {
        super(instance);
        this.typeConverterDelegate = new JuffrouTypeConverterDelegate(this, instance);
    }

    public void setBean(Object bean) {
        super.setBean(bean);
        this.typeConverterDelegate = new JuffrouTypeConverterDelegate(this, bean);
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setExtractOldValueForEditor(boolean extractOldValueForEditor) {
        this.extractOldValueForEditor = extractOldValueForEditor;
    }

    public boolean isExtractOldValueForEditor() {
        return this.extractOldValueForEditor;
    }

    public boolean isReadableProperty(String propertyName) {
        Assert.notNull((Object)propertyName, (String)"Property name must not be null");
        return this.getContext().getFields().keySet().contains(propertyName);
    }

    public boolean isWritableProperty(String propertyName) {
        Assert.notNull((Object)propertyName, (String)"Property name must not be null");
        return this.getContext().getFields().keySet().contains(propertyName);
    }

    public Class getPropertyType(String propertyName) throws BeansException {
        return super.getClazz(propertyName);
    }

    public TypeDescriptor getPropertyTypeDescriptor(String propertyName) throws BeansException {
        return new TypeDescriptor(this.getContext().getBeanFieldHandler(propertyName).getField());
    }

    public Object getPropertyValue(String propertyName) throws BeansException {
        try {
            return super.getValue(propertyName);
        }
        catch (InvalidPropertyException e) {
            throw new org.springframework.beans.InvalidPropertyException(e.getClazz(), e.getPropertyName(), e.getMessage(), (Throwable)e);
        }
    }

    public void setPropertyValue(String propertyName, Object value) throws BeansException {
        try {
            if (value != null && String.class == value.getClass()) {
                super.setValueOfString(propertyName, (String)value);
            } else {
                super.setValue(propertyName, value);
            }
        }
        catch (IllegalArgumentException e) {
            throw new TypeMismatchException(value, null, (Throwable)e);
        }
    }

    public void setPropertyValue(PropertyValue pv) throws BeansException {
        super.setValue(pv.getName(), pv.getValue());
    }

    public void setPropertyValues(Map<?, ?> map) throws BeansException {
        this.setPropertyValues((PropertyValues)new MutablePropertyValues(map));
    }

    public void setPropertyValues(PropertyValues pvs) throws BeansException {
        this.setPropertyValues(pvs, false, false);
    }

    public void setPropertyValues(PropertyValues pvs, boolean ignoreUnknown) throws BeansException {
        this.setPropertyValues(pvs, ignoreUnknown, false);
    }

    public void setPropertyValues(PropertyValues pvs, boolean ignoreUnknown, boolean ignoreInvalid) throws BeansException {
        List<PropertyValue> propertyValues = pvs instanceof MutablePropertyValues ? ((MutablePropertyValues)pvs).getPropertyValueList() : Arrays.asList(pvs.getPropertyValues());
        for (PropertyValue pv : propertyValues) {
            super.setValue(pv.getName(), pv.getValue());
        }
    }

    public void registerCustomEditor(Class<?> requiredType, PropertyEditor propertyEditor) {
        this.registerCustomEditor(requiredType, null, propertyEditor);
    }

    public void registerCustomEditor(Class<?> requiredType, String propertyPath, PropertyEditor propertyEditor) {
        if (requiredType == null && propertyPath == null) {
            throw new IllegalArgumentException("Either requiredType or propertyPath is required");
        }
        if (propertyPath != null) {
            if (this.customEditorsForPath == null) {
                this.customEditorsForPath = new LinkedHashMap<String, CustomEditorHolder>(16);
            }
            this.customEditorsForPath.put(propertyPath, new CustomEditorHolder(propertyEditor, requiredType));
        } else {
            if (this.customEditors == null) {
                this.customEditors = new LinkedHashMap(16);
            }
            this.customEditors.put(requiredType, propertyEditor);
            this.customEditorCache = null;
        }
    }

    public PropertyEditor findCustomEditor(Class<?> requiredType, String propertyPath) {
        Class requiredTypeToUse = requiredType;
        if (propertyPath != null) {
            if (this.customEditorsForPath != null) {
                PropertyEditor editor = this.getCustomEditor(propertyPath, requiredType);
                if (editor == null) {
                    LinkedList<String> strippedPaths = new LinkedList<String>();
                    this.addStrippedPropertyPaths(strippedPaths, "", propertyPath);
                    Iterator it = strippedPaths.iterator();
                    while (it.hasNext() && editor == null) {
                        String strippedPath = (String)it.next();
                        editor = this.getCustomEditor(strippedPath, requiredType);
                    }
                }
                if (editor != null) {
                    return editor;
                }
            }
            if (requiredType == null) {
                requiredTypeToUse = this.getPropertyType(propertyPath);
            }
        }
        return this.getCustomEditor(requiredTypeToUse);
    }

    private void addStrippedPropertyPaths(List<String> strippedPaths, String nestedPath, String propertyPath) {
        int endIndex;
        int startIndex = propertyPath.indexOf(91);
        if (startIndex != -1 && (endIndex = propertyPath.indexOf(93)) != -1) {
            String prefix = propertyPath.substring(0, startIndex);
            String key = propertyPath.substring(startIndex, endIndex + 1);
            String suffix = propertyPath.substring(endIndex + 1, propertyPath.length());
            strippedPaths.add(nestedPath + prefix + suffix);
            this.addStrippedPropertyPaths(strippedPaths, nestedPath + prefix, suffix);
            this.addStrippedPropertyPaths(strippedPaths, nestedPath + prefix + key, suffix);
        }
    }

    private PropertyEditor getCustomEditor(String propertyName, Class<?> requiredType) {
        CustomEditorHolder holder = this.customEditorsForPath.get(propertyName);
        return holder != null ? holder.getPropertyEditor(requiredType) : null;
    }

    private PropertyEditor getCustomEditor(Class<?> requiredType) {
        if (requiredType == null || this.customEditors == null) {
            return null;
        }
        PropertyEditor editor = this.customEditors.get(requiredType);
        if (editor == null) {
            if (this.customEditorCache != null) {
                editor = this.customEditorCache.get(requiredType);
            }
            if (editor == null) {
                Iterator<Class<?>> it = this.customEditors.keySet().iterator();
                while (it.hasNext() && editor == null) {
                    Class<?> key = it.next();
                    if (!key.isAssignableFrom(requiredType)) continue;
                    editor = this.customEditors.get(key);
                    if (this.customEditorCache == null) {
                        this.customEditorCache = new HashMap();
                    }
                    this.customEditorCache.put(requiredType, editor);
                }
            }
        }
        return editor;
    }

    public boolean hasCustomEditorForElement(Class<?> elementType, String propertyPath) {
        if (propertyPath != null && this.customEditorsForPath != null) {
            for (Map.Entry<String, CustomEditorHolder> entry : this.customEditorsForPath.entrySet()) {
                if (!PropertyAccessorUtils.matchesProperty((String)entry.getKey(), (String)propertyPath) || entry.getValue().getPropertyEditor(elementType) == null) continue;
                return true;
            }
        }
        return elementType != null && this.customEditors != null && this.customEditors.containsKey(elementType);
    }

    public boolean isSharedEditor(PropertyEditor propertyEditor) {
        return this.sharedEditors != null && this.sharedEditors.contains(propertyEditor);
    }

    public PropertyEditor getDefaultEditor(Class<?> requiredType) {
        ((Object)((Object)this)).getClass();
        return null;
    }

    public void useConfigValueEditors() {
        this.configValueEditorsActive = true;
    }

    private void createDefaultEditors() {
        this.defaultEditors = new HashMap(64);
        this.defaultEditors.put(Charset.class, (PropertyEditor)new CharsetEditor());
        this.defaultEditors.put(Class.class, (PropertyEditor)new ClassEditor());
        this.defaultEditors.put(Class[].class, (PropertyEditor)new ClassArrayEditor());
        this.defaultEditors.put(Currency.class, (PropertyEditor)new CurrencyEditor());
        this.defaultEditors.put(File.class, (PropertyEditor)new FileEditor());
        this.defaultEditors.put(InputStream.class, (PropertyEditor)new InputStreamEditor());
        this.defaultEditors.put(InputSource.class, (PropertyEditor)new InputSourceEditor());
        this.defaultEditors.put(Locale.class, (PropertyEditor)new LocaleEditor());
        this.defaultEditors.put(Pattern.class, (PropertyEditor)new PatternEditor());
        this.defaultEditors.put(Properties.class, (PropertyEditor)new PropertiesEditor());
        this.defaultEditors.put(Resource[].class, (PropertyEditor)new ResourceArrayPropertyEditor());
        this.defaultEditors.put(TimeZone.class, (PropertyEditor)new TimeZoneEditor());
        this.defaultEditors.put(URI.class, (PropertyEditor)new URIEditor());
        this.defaultEditors.put(URL.class, (PropertyEditor)new URLEditor());
        this.defaultEditors.put(UUID.class, (PropertyEditor)new UUIDEditor());
        this.defaultEditors.put(Collection.class, (PropertyEditor)new CustomCollectionEditor(Collection.class));
        this.defaultEditors.put(Set.class, (PropertyEditor)new CustomCollectionEditor(Set.class));
        this.defaultEditors.put(SortedSet.class, (PropertyEditor)new CustomCollectionEditor(SortedSet.class));
        this.defaultEditors.put(List.class, (PropertyEditor)new CustomCollectionEditor(List.class));
        this.defaultEditors.put(SortedMap.class, (PropertyEditor)new CustomMapEditor(SortedMap.class));
        this.defaultEditors.put(byte[].class, (PropertyEditor)new ByteArrayPropertyEditor());
        this.defaultEditors.put(char[].class, (PropertyEditor)new CharArrayPropertyEditor());
        this.defaultEditors.put(Character.TYPE, (PropertyEditor)new CharacterEditor(false));
        this.defaultEditors.put(Character.class, (PropertyEditor)new CharacterEditor(true));
        this.defaultEditors.put(Boolean.TYPE, (PropertyEditor)new CustomBooleanEditor(false));
        this.defaultEditors.put(Boolean.class, (PropertyEditor)new CustomBooleanEditor(true));
        this.defaultEditors.put(Byte.TYPE, (PropertyEditor)new CustomNumberEditor(Byte.class, false));
        this.defaultEditors.put(Byte.class, (PropertyEditor)new CustomNumberEditor(Byte.class, true));
        this.defaultEditors.put(Short.TYPE, (PropertyEditor)new CustomNumberEditor(Short.class, false));
        this.defaultEditors.put(Short.class, (PropertyEditor)new CustomNumberEditor(Short.class, true));
        this.defaultEditors.put(Integer.TYPE, (PropertyEditor)new CustomNumberEditor(Integer.class, false));
        this.defaultEditors.put(Integer.class, (PropertyEditor)new CustomNumberEditor(Integer.class, true));
        this.defaultEditors.put(Long.TYPE, (PropertyEditor)new CustomNumberEditor(Long.class, false));
        this.defaultEditors.put(Long.class, (PropertyEditor)new CustomNumberEditor(Long.class, true));
        this.defaultEditors.put(Float.TYPE, (PropertyEditor)new CustomNumberEditor(Float.class, false));
        this.defaultEditors.put(Float.class, (PropertyEditor)new CustomNumberEditor(Float.class, true));
        this.defaultEditors.put(Double.TYPE, (PropertyEditor)new CustomNumberEditor(Double.class, false));
        this.defaultEditors.put(Double.class, (PropertyEditor)new CustomNumberEditor(Double.class, true));
        this.defaultEditors.put(BigDecimal.class, (PropertyEditor)new CustomNumberEditor(BigDecimal.class, true));
        this.defaultEditors.put(BigInteger.class, (PropertyEditor)new CustomNumberEditor(BigInteger.class, true));
        if (this.configValueEditorsActive) {
            StringArrayPropertyEditor sae = new StringArrayPropertyEditor();
            this.defaultEditors.put(String[].class, (PropertyEditor)sae);
            this.defaultEditors.put(short[].class, (PropertyEditor)sae);
            this.defaultEditors.put(int[].class, (PropertyEditor)sae);
            this.defaultEditors.put(long[].class, (PropertyEditor)sae);
        }
    }

    public <T> T convertIfNecessary(Object value, Class<T> requiredType) throws TypeMismatchException {
        return this.convertIfNecessary(value, requiredType, null);
    }

    public <T> T convertIfNecessary(Object value, Class<T> requiredType, MethodParameter methodParam) throws TypeMismatchException {
        try {
            return this.typeConverterDelegate.convertIfNecessary(value, requiredType, methodParam);
        }
        catch (ConverterNotFoundException ex) {
            throw new ConversionNotSupportedException(value, requiredType, (Throwable)ex);
        }
        catch (ConversionException ex) {
            throw new TypeMismatchException(value, requiredType, (Throwable)ex);
        }
        catch (IllegalStateException ex) {
            throw new ConversionNotSupportedException(value, requiredType, (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            throw new TypeMismatchException(value, requiredType, (Throwable)ex);
        }
    }

    public Object getWrappedInstance() {
        return super.getBean();
    }

    public Class getWrappedClass() {
        return super.getBeanClass();
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        String[] propertyNames = this.getPropertyNames();
        PropertyDescriptor[] descriptors = new PropertyDescriptor[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            descriptors[i] = this.getPropertyDescriptor(propertyNames[i]);
        }
        return descriptors;
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) throws org.springframework.beans.InvalidPropertyException {
        BeanFieldHandler beanFieldHandler = this.getContext().getBeanFieldHandler(propertyName);
        try {
            return new JuffrouPropertyDescriptor(this.getClazz(propertyName), beanFieldHandler);
        }
        catch (IntrospectionException e) {
            throw new org.springframework.beans.InvalidPropertyException(this.getClazz(propertyName), propertyName, "Cannot create PropertyDescriptor", (Throwable)e);
        }
    }

    public void setAutoGrowNestedPaths(boolean autoGrowNestedPaths) {
    }

    public boolean isAutoGrowNestedPaths() {
        return true;
    }

    public void setAutoGrowCollectionLimit(int autoGrowCollectionLimit) {
    }

    public int getAutoGrowCollectionLimit() {
        return 0;
    }

    private static class CustomEditorHolder {
        private final PropertyEditor propertyEditor;
        private final Class<?> registeredType;

        private CustomEditorHolder(PropertyEditor propertyEditor, Class<?> registeredType) {
            this.propertyEditor = propertyEditor;
            this.registeredType = registeredType;
        }

        private PropertyEditor getPropertyEditor() {
            return this.propertyEditor;
        }

        private Class<?> getRegisteredType() {
            return this.registeredType;
        }

        private PropertyEditor getPropertyEditor(Class<?> requiredType) {
            if (this.registeredType == null || requiredType != null && (ClassUtils.isAssignable(this.registeredType, requiredType) || ClassUtils.isAssignable(requiredType, this.registeredType)) || requiredType == null && !Collection.class.isAssignableFrom(this.registeredType) && !this.registeredType.isArray()) {
                return this.propertyEditor;
            }
            return null;
        }
    }
}

