/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juffrou.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.juffrou.xml.JuffrouXml;
import net.sf.juffrou.xml.internal.io.JuffrouReader;
import net.sf.juffrou.xml.internal.io.JuffrouWriter;
import net.sf.juffrou.xml.internal.io.XmlReader;
import net.sf.juffrou.xml.internal.io.XmlWriter;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.support.AbstractMarshaller;
import org.springframework.util.xml.StaxUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class JuffrouMarshaller
extends AbstractMarshaller {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private final JuffrouXml juffrouXml = new JuffrouXml();
    private String encoding = "UTF-8";

    public boolean supports(Class<?> clazz) {
        return true;
    }

    protected void marshalDomNode(Object graph, Node node) throws XmlMappingException {
        XmlWriter writer = new XmlWriter(node);
        this.juffrouXml.getXmlMarshaller().marshallBean((JuffrouWriter)writer, graph);
    }

    protected void marshalXmlEventWriter(Object graph, XMLEventWriter eventWriter) throws XmlMappingException {
        this.marshalSaxHandlers(graph, StaxUtils.createContentHandler((XMLEventWriter)eventWriter), null);
    }

    protected void marshalXmlStreamWriter(Object graph, XMLStreamWriter streamWriter) throws XmlMappingException {
        this.marshalSaxHandlers(graph, StaxUtils.createContentHandler((XMLStreamWriter)streamWriter), null);
    }

    protected void marshalOutputStream(Object graph, OutputStream outputStream) throws XmlMappingException, IOException {
        this.marshalWriter(graph, new OutputStreamWriter(outputStream, this.encoding));
    }

    protected void marshalSaxHandlers(Object graph, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws XmlMappingException {
        XmlWriter jwriter = new XmlWriter();
        this.juffrouXml.getXmlMarshaller().marshallBean((JuffrouWriter)jwriter, graph);
        DOMSource source = jwriter.getSource();
        Node node = source.getNode();
        try {
            contentHandler.startDocument();
            this.fillContentHandlerFomNode(contentHandler, node);
            contentHandler.endDocument();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    private void fillContentHandlerFomNode(ContentHandler contentHandler, Node node) throws SAXException {
        while (node != null) {
            contentHandler.startElement(node.getBaseURI(), node.getLocalName(), node.getNodeName(), this.getAttributesFormNamedNodeMap(node.getAttributes()));
            this.fillContentHandlerFomNode(contentHandler, node.getFirstChild());
            contentHandler.endElement(node.getBaseURI(), node.getLocalName(), node.getNodeName());
            node = node.getNextSibling();
        }
    }

    private Attributes getAttributesFormNamedNodeMap(NamedNodeMap namedNodeMap) {
        AttributesImpl attributes = new AttributesImpl();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node item = namedNodeMap.item(i);
            attributes.addAttribute(item.getBaseURI(), item.getLocalName(), item.getNodeName(), "CDATA", item.getNodeValue());
        }
        return attributes;
    }

    protected void marshalWriter(Object graph, Writer writer) throws XmlMappingException, IOException {
        XmlWriter jwriter = new XmlWriter();
        this.juffrouXml.getXmlMarshaller().marshallBean((JuffrouWriter)jwriter, graph);
        Transformer transformer = jwriter.getTransformer();
        DOMSource source = jwriter.getSource();
        StreamResult result = new StreamResult(writer);
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    protected Object unmarshalDomNode(Node node) throws XmlMappingException {
        XmlReader xmlReader = new XmlReader(node);
        Object unmarshallBean = this.juffrouXml.getXmlMarshaller().unmarshallBean((JuffrouReader)xmlReader);
        return unmarshallBean;
    }

    protected Object unmarshalXmlEventReader(XMLEventReader eventReader) throws XmlMappingException {
        return null;
    }

    protected Object unmarshalXmlStreamReader(XMLStreamReader streamReader) throws XmlMappingException {
        return null;
    }

    protected Object unmarshalInputStream(InputStream inputStream) throws XmlMappingException, IOException {
        XmlReader xmlReader = new XmlReader(inputStream);
        Object unmarshallBean = this.juffrouXml.getXmlMarshaller().unmarshallBean((JuffrouReader)xmlReader);
        return unmarshallBean;
    }

    protected Object unmarshalReader(Reader reader) throws XmlMappingException, IOException {
        XmlReader xmlReader = new XmlReader(new InputSource(reader));
        Object unmarshallBean = this.juffrouXml.getXmlMarshaller().unmarshallBean((JuffrouReader)xmlReader);
        return unmarshallBean;
    }

    protected Object unmarshalSaxReader(XMLReader xmlReader, InputSource inputSource) throws XmlMappingException, IOException {
        XmlReader reader = new XmlReader(inputSource);
        Object unmarshallBean = this.juffrouXml.getXmlMarshaller().unmarshallBean((JuffrouReader)reader);
        return unmarshallBean;
    }
}

