/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juffrou.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.juffrou.reflect.BeanWrapperFactory;
import net.sf.juffrou.reflect.DefaultBeanWrapperFactory;
import net.sf.juffrou.reflect.ReflectionUtil;
import net.sf.juffrou.reflect.error.BeanInstanceBuilderException;
import net.sf.juffrou.reflect.error.CannotWrapInterfaceException;
import net.sf.juffrou.reflect.error.InvalidPropertyException;
import net.sf.juffrou.reflect.error.ReflectionException;
import net.sf.juffrou.reflect.internal.BeanCollectionFieldHandler;
import net.sf.juffrou.reflect.internal.BeanFieldHandler;

public class BeanWrapperContext {
    private final Class clazz;
    private final Map<TypeVariable<?>, Type> typeArgumentsMap;
    private final Map<String, BeanFieldHandler> fields;
    private final BeanWrapperFactory bwFactory;

    public static final BeanWrapperContext create(Class clazz) {
        DefaultBeanWrapperFactory factory = new DefaultBeanWrapperFactory();
        return factory.getBeanWrapperContext(clazz);
    }

    public static final BeanWrapperContext create(Class clazz, Type ... types) {
        DefaultBeanWrapperFactory factory = new DefaultBeanWrapperFactory();
        return factory.getBeanWrapperContext(clazz, types);
    }

    protected BeanWrapperContext(BeanWrapperFactory factory, Class clazz, Type ... types) {
        if (factory == null) {
            throw new IllegalArgumentException("BeanWrapperFactory cannot be null");
        }
        if (clazz.isInterface()) {
            throw new CannotWrapInterfaceException("Cannot create a bean wrapper around an object of type " + clazz.getSimpleName());
        }
        this.bwFactory = factory;
        this.typeArgumentsMap = new HashMap();
        TypeVariable<Class<T>>[] typeParameters = clazz.getTypeParameters();
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                this.typeArgumentsMap.put(typeParameters[i], types[i]);
            }
        } else if (typeParameters != null && typeParameters.length > 0) {
            for (TypeVariable typeVariable : typeParameters) {
                this.typeArgumentsMap.put(typeVariable, (Type)((Object)Object.class));
            }
        }
        this.clazz = clazz;
        this.typeArgumentsMap.putAll(ReflectionUtil.getTypeArgumentsMap(Class.class, clazz));
        this.fields = new LinkedHashMap<String, BeanFieldHandler>();
        this.initFieldInfo(this.clazz, this.fields);
    }

    private void initFieldInfo(Class<?> clazz, Map<String, BeanFieldHandler> fs) {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != Object.class) {
            this.initFieldInfo(superclass, fs);
        }
        for (Field f : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            if (Collection.class.isAssignableFrom(f.getType())) {
                fs.put(f.getName(), new BeanCollectionFieldHandler(this, f));
                continue;
            }
            fs.put(f.getName(), new BeanFieldHandler(this, f));
        }
    }

    public BeanWrapperContext getNestedContext(String thisProperty, Object propertyValue) {
        Type propertyType = propertyValue != null ? propertyValue.getClass() : this.getBeanFieldHandler(thisProperty).getGenericType();
        BeanWrapperContext nestedContext = propertyType instanceof ParameterizedType ? this.bwFactory.getBeanWrapperContext((Class)((ParameterizedType)propertyType).getRawType(), ((ParameterizedType)propertyType).getActualTypeArguments()) : this.bwFactory.getBeanWrapperContext((Class)propertyType);
        return nestedContext;
    }

    public BeanFieldHandler getBeanFieldHandler(String propertyName) {
        BeanFieldHandler bfh = this.fields.get(propertyName);
        if (bfh == null) {
            Method getter = null;
            Method setter = null;
            try {
                getter = BeanFieldHandler.inspectReadMethod(this.clazz, propertyName, null);
            }
            catch (ReflectionException reflectionException) {
                // empty catch block
            }
            try {
                setter = BeanFieldHandler.inspectWriteMethod(this.clazz, propertyName, null);
            }
            catch (ReflectionException reflectionException) {
                // empty catch block
            }
            if (getter == null && setter == null) {
                throw new InvalidPropertyException(this.clazz, propertyName);
            }
            bfh = new BeanFieldHandler(this, getter, setter);
            this.fields.put(propertyName, bfh);
        }
        return bfh;
    }

    public Type getType(String propertyName) {
        int nestedIndex = propertyName.indexOf(46);
        if (nestedIndex == -1) {
            return this.getBeanFieldHandler(propertyName).getGenericType();
        }
        String thisProperty = propertyName.substring(0, nestedIndex);
        String nestedProperty = propertyName.substring(nestedIndex + 1);
        BeanWrapperContext nestedContext = this.getNestedContext(thisProperty, null);
        return nestedContext.getType(nestedProperty);
    }

    public Class<?> getBeanClass() {
        return this.clazz;
    }

    public Object newBeanInstance() {
        try {
            return this.bwFactory.getBeanInstanceBuilder().build(this.clazz);
        }
        catch (BeanInstanceBuilderException e) {
            throw new ReflectionException(e);
        }
    }

    public Map<String, BeanFieldHandler> getFields() {
        return this.fields;
    }

    public Map<TypeVariable<?>, Type> getTypeArgumentsMap() {
        return this.typeArgumentsMap;
    }

    public BeanWrapperFactory getFactory() {
        return this.bwFactory;
    }
}

