/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juffrou.reflect.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import net.sf.juffrou.reflect.BeanWrapperContext;
import net.sf.juffrou.reflect.JuffrouBeanWrapper;
import net.sf.juffrou.reflect.error.ReflectionException;
import net.sf.juffrou.reflect.internal.BeanFieldHandler;

public class BeanCollectionFieldHandler
extends BeanFieldHandler {
    private String[] pluralSufixes = new String[]{"es", "s"};
    private AccessType accessType = this.getTypeArguments() != null ? AccessType.THROUGHBEAN : AccessType.DIRECT;
    private Method adder = null;
    private Method remover = null;

    public BeanCollectionFieldHandler(BeanWrapperContext context, Field field) {
        super(context, field);
    }

    public BeanCollectionFieldHandler(BeanWrapperContext context, Method getterMethod, Method setterMethod) {
        super(context, getterMethod, setterMethod);
    }

    public void addElement(JuffrouBeanWrapper bw, Object element) {
        if (this.accessType == AccessType.THROUGHBEAN && this.adder == null) {
            this.adder = this.inspectMethod(bw.getBeanClass(), this.getField().getName(), "add");
            if (this.adder != null) {
                try {
                    this.adder.invoke(bw.getBean(), element);
                    return;
                }
                catch (IllegalAccessException e) {
                    throw new ReflectionException(e);
                }
                catch (InvocationTargetException e) {
                    throw new ReflectionException(e);
                }
            }
        }
        this.addDirectlyToCollection(bw, element);
    }

    public void removeElement(JuffrouBeanWrapper bw, Object element) {
        if (this.accessType == AccessType.THROUGHBEAN && this.remover == null) {
            this.remover = this.inspectMethod(bw.getBeanClass(), this.getField().getName(), "remove");
            if (this.remover != null) {
                try {
                    this.remover.invoke(bw.getBean(), element);
                    return;
                }
                catch (IllegalAccessException e) {
                    throw new ReflectionException(e);
                }
                catch (InvocationTargetException e) {
                    throw new ReflectionException(e);
                }
            }
        }
        this.removeDirectlyFromCollection(bw, element);
    }

    private void addDirectlyToCollection(JuffrouBeanWrapper bw, Object element) {
        Collection collection = (Collection)this.getValue(bw);
        collection.add(element);
    }

    private void removeDirectlyFromCollection(JuffrouBeanWrapper bw, Object element) {
        Collection collection = (Collection)this.getValue(bw);
        collection.remove(element);
    }

    public Method inspectMethod(Class<?> beanClass, String fieldName, String methodPrefix) {
        Type type = this.getTypeArguments()[0];
        if (type != null && type instanceof Class) {
            Class argumentClass = (Class)type;
            String methodName = methodPrefix + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            try {
                return beanClass.getMethod(methodName, argumentClass);
            }
            catch (NoSuchMethodException | SecurityException e) {
                for (String suffix : this.pluralSufixes) {
                    if (!methodName.endsWith("es")) continue;
                    methodName = methodName.substring(0, methodName.lastIndexOf("es"));
                    try {
                        return beanClass.getMethod(methodName, argumentClass);
                    }
                    catch (NoSuchMethodException | SecurityException exception) {
                        // empty catch block
                    }
                }
            }
        }
        this.accessType = AccessType.DIRECT;
        return null;
    }

    private static enum AccessType {
        DIRECT,
        THROUGHBEAN;

    }
}

