/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juffrou.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.juffrou.reflect.CustomizableBeanWrapperFactory;
import net.sf.juffrou.reflect.JuffrouBeanWrapper;

public final class ReflectionUtil {
    public static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionUtil.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = ReflectionUtil.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            Object genericDeclaration = typeVariable.getGenericDeclaration();
            return type.getClass();
        }
        return null;
    }

    public static <T> List<Class<?>> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        HashMap resolvedTypes = new HashMap();
        Type type = childClass;
        while (type != null && !ReflectionUtil.getClass(type).equals(baseClass)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
            }
            if (rawType.equals(baseClass)) continue;
            type = rawType.getGenericSuperclass();
        }
        Object actualTypeArguments = type instanceof Class ? type.getTypeParameters() : (type != null ? ((ParameterizedType)type).getActualTypeArguments() : null);
        ArrayList typeArgumentsAsClasses = new ArrayList();
        if (actualTypeArguments == null || ((Type[])actualTypeArguments).length == 0) {
            for (Type baseType : resolvedTypes.values()) {
                typeArgumentsAsClasses.add(ReflectionUtil.getClass(baseType));
            }
        } else {
            for (Type baseType : actualTypeArguments) {
                while (resolvedTypes.containsKey(baseType)) {
                    baseType = (Type)resolvedTypes.get(baseType);
                }
                typeArgumentsAsClasses.add(ReflectionUtil.getClass(baseType));
            }
        }
        return typeArgumentsAsClasses;
    }

    public static <T> Map<TypeVariable<?>, Type> getTypeArgumentsMap(Class<T> baseClass, Class<? extends T> childClass) {
        HashMap resolvedTypes = new HashMap();
        Type type = childClass;
        while (type != null && !ReflectionUtil.getClass(type).equals(baseClass)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
            }
            if (rawType.equals(baseClass)) continue;
            type = rawType.getGenericSuperclass();
        }
        return resolvedTypes;
    }

    public static boolean isSimpleType(Type type) {
        if (!(type instanceof Class)) {
            return false;
        }
        Class clazz = (Class)type;
        return clazz.isPrimitive() || clazz.isEnum() || clazz.isInterface() || clazz.getName().startsWith("java");
    }

    public static Map<String, Object> getMapFromBean(Object bean) {
        return ReflectionUtil.getMapFromBean(new CustomizableBeanWrapperFactory(), bean);
    }

    public static Map<String, Object> getMapFromBean(CustomizableBeanWrapperFactory factory, Object bean) {
        HashMap<String, Object> beanMap = new HashMap<String, Object>();
        HashMap<Object, String> circularReferences = new HashMap<Object, String>();
        JuffrouBeanWrapper beanWrapper = factory.getBeanWrapper(bean);
        circularReferences.put(bean, "");
        ReflectionUtil.buildMapFromBean(factory, beanWrapper, circularReferences, "", beanMap);
        return beanMap;
    }

    private static void buildMapFromBean(CustomizableBeanWrapperFactory factory, JuffrouBeanWrapper beanWrapper, Map<Object, String> circularReferences, String pathPrefix, Map<String, Object> beanMap) {
        for (String propertyName : beanWrapper.getPropertyNames()) {
            Object value = beanWrapper.getValue(propertyName);
            if (value == null) continue;
            if (ReflectionUtil.isSimpleType(beanWrapper.getType(propertyName))) {
                beanMap.put(pathPrefix + propertyName, value);
                continue;
            }
            if (circularReferences.containsKey(value)) {
                beanMap.put(pathPrefix + propertyName, new CircularReference(circularReferences.get(value)));
                continue;
            }
            circularReferences.put(value, pathPrefix + propertyName);
            ReflectionUtil.buildMapFromBean(factory, beanWrapper.getLocalNestedWrapper(propertyName), circularReferences, pathPrefix + propertyName + ".", beanMap);
        }
    }

    public static void getBeanFromMap(Map<String, Object> beanMap, Object bean) {
        ReflectionUtil.getBeanFromMap(new CustomizableBeanWrapperFactory(), beanMap, bean);
    }

    public static void getBeanFromMap(CustomizableBeanWrapperFactory factory, Map<String, Object> beanMap, Object bean) {
        HashMap<String, CircularReference> circularReferences = new HashMap<String, CircularReference>();
        JuffrouBeanWrapper beanWrapper = factory.getBeanWrapper(bean);
        for (Map.Entry<String, Object> entry : beanMap.entrySet()) {
            if (entry.getValue() instanceof CircularReference) {
                circularReferences.put(entry.getKey(), (CircularReference)entry.getValue());
                continue;
            }
            beanWrapper.setValue(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : circularReferences.entrySet()) {
            beanWrapper.setValue(entry.getKey(), ((CircularReference)entry.getValue()).getPath().isEmpty() ? beanWrapper.getBean() : beanWrapper.getValue(((CircularReference)entry.getValue()).getPath()));
        }
    }

    private static class CircularReference {
        private final String path;

        private CircularReference(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }
}

