/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juffrou.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.juffrou.reflect.BeanWrapperContext;
import net.sf.juffrou.reflect.BeanWrapperFactory;
import net.sf.juffrou.reflect.ReflectionUtil;
import net.sf.juffrou.reflect.error.ReflectionException;
import net.sf.juffrou.reflect.internal.BeanFieldHandler;

public class JuffrouBeanWrapper {
    private final BeanWrapperContext context;
    private final JuffrouBeanWrapper parentBeanWrapper;
    private final String parentBeanProperty;
    private Object wrappedInstance;
    private final Map<String, JuffrouBeanWrapper> nestedWrappers = new HashMap<String, JuffrouBeanWrapper>();

    public JuffrouBeanWrapper(BeanWrapperContext context) {
        this.context = context;
        this.wrappedInstance = null;
        this.parentBeanWrapper = null;
        this.parentBeanProperty = null;
    }

    public JuffrouBeanWrapper(BeanWrapperContext context, Object instance) {
        if (!context.getBeanClass().isAssignableFrom(instance.getClass())) {
            throw new InvalidParameterException("Bean must be of type " + context.getBeanClass().getSimpleName());
        }
        this.context = context;
        this.parentBeanWrapper = null;
        this.parentBeanProperty = null;
        this.wrappedInstance = instance;
    }

    public JuffrouBeanWrapper(BeanWrapperContext context, JuffrouBeanWrapper parentBeanWrapper, String parentBeanProperty) {
        this.context = context;
        this.wrappedInstance = null;
        this.parentBeanWrapper = parentBeanWrapper;
        this.parentBeanProperty = parentBeanProperty;
    }

    public JuffrouBeanWrapper(Object instance) {
        this.wrappedInstance = instance;
        this.context = BeanWrapperContext.create(instance.getClass());
        this.parentBeanWrapper = null;
        this.parentBeanProperty = null;
    }

    public JuffrouBeanWrapper(Class<?> clazz) {
        this.context = BeanWrapperContext.create(clazz);
        this.wrappedInstance = null;
        this.parentBeanWrapper = null;
        this.parentBeanProperty = null;
    }

    private boolean isRoot() {
        return this.parentBeanWrapper == null;
    }

    public BeanWrapperContext getContext() {
        return this.context;
    }

    public BeanWrapperFactory getFactory() {
        return this.context.getFactory();
    }

    public Object getBean(boolean instantiateIfNull) {
        if (this.isRoot()) {
            if (this.wrappedInstance == null && instantiateIfNull) {
                this.createInstance();
            }
            return this.wrappedInstance;
        }
        return this.parentBeanWrapper.getContext().getBeanFieldHandler(this.parentBeanProperty).getValue(this.parentBeanWrapper);
    }

    public Object getBean() {
        if (this.isRoot()) {
            if (this.wrappedInstance == null) {
                this.createInstance();
            }
            return this.wrappedInstance;
        }
        return this.parentBeanWrapper.getContext().getBeanFieldHandler(this.parentBeanProperty).getValue(this.parentBeanWrapper);
    }

    public void setBean(Object bean) {
        if (bean != null && !this.context.getBeanClass().isAssignableFrom(bean.getClass())) {
            throw new InvalidParameterException("Bean must be of type " + this.context.getBeanClass().getSimpleName());
        }
        if (this.isRoot()) {
            this.wrappedInstance = bean;
        } else {
            this.parentBeanWrapper.setValue(this.parentBeanProperty, bean);
        }
    }

    public Class<?> getBeanClass() {
        return this.context.getBeanClass();
    }

    public Map<String, JuffrouBeanWrapper> getNestedWrappers() {
        return this.nestedWrappers;
    }

    public boolean hasProperty(String propertyName) {
        int nestedIndex = propertyName.indexOf(46);
        if (nestedIndex == -1) {
            return this.context.getFields().containsKey(propertyName);
        }
        String thisProperty = propertyName.substring(0, nestedIndex);
        String nestedProperty = propertyName.substring(nestedIndex + 1);
        JuffrouBeanWrapper nestedWrapper = this.getLocalNestedWrapper(thisProperty);
        return nestedWrapper.hasProperty(nestedProperty);
    }

    public String[] getPropertyNames() {
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.addAll(this.context.getFields().keySet());
        return propertyNames.toArray(new String[0]);
    }

    public String toString() {
        Object instance = this.getBean();
        return instance == null ? "" : instance.toString();
    }

    public Object getValue(String propertyName) {
        if (this.getBean() == null) {
            return null;
        }
        int nestedIndex = propertyName.indexOf(46);
        if (nestedIndex == -1) {
            return this.context.getBeanFieldHandler(propertyName).getValue(this);
        }
        String thisProperty = propertyName.substring(0, nestedIndex);
        String nestedProperty = propertyName.substring(nestedIndex + 1);
        JuffrouBeanWrapper nestedWrapper = this.getLocalNestedWrapper(thisProperty);
        return nestedWrapper.getValue(nestedProperty);
    }

    public Class<?> getClazz(String propertyName) {
        return ReflectionUtil.getClass(this.getType(propertyName));
    }

    public Type getType(String propertyName) {
        int nestedIndex = propertyName.indexOf(46);
        if (nestedIndex == -1) {
            Object value;
            Object object = value = this.getBean() == null ? null : this.context.getBeanFieldHandler(propertyName).getValue(this);
            if (value != null) {
                return value.getClass();
            }
            return this.context.getBeanFieldHandler(propertyName).getGenericType();
        }
        String thisProperty = propertyName.substring(0, nestedIndex);
        Object value = this.context.getBeanFieldHandler(thisProperty).getValue(this);
        String nestedProperty = propertyName.substring(nestedIndex + 1);
        BeanWrapperContext nestedContext = this.context.getNestedContext(thisProperty, value);
        return nestedContext.getType(nestedProperty);
    }

    public Type[] getTypeArguments(String propertyName) {
        int nestedIndex = propertyName.indexOf(46);
        if (nestedIndex == -1) {
            return this.context.getBeanFieldHandler(propertyName).getTypeArguments();
        }
        String thisProperty = propertyName.substring(0, nestedIndex);
        String nestedProperty = propertyName.substring(nestedIndex + 1);
        JuffrouBeanWrapper nestedWrapper = this.getLocalNestedWrapper(thisProperty);
        return nestedWrapper.getTypeArguments(nestedProperty);
    }

    public Field getField(String propertyName) {
        int nestedIndex = propertyName.indexOf(46);
        if (nestedIndex == -1) {
            return this.context.getBeanFieldHandler(propertyName).getField();
        }
        String thisProperty = propertyName.substring(0, nestedIndex);
        String nestedProperty = propertyName.substring(nestedIndex + 1);
        JuffrouBeanWrapper nestedWrapper = this.getLocalNestedWrapper(thisProperty);
        return nestedWrapper.getField(nestedProperty);
    }

    public void setValueOfString(String propertyName, String value) {
        int nestedIndex;
        if (this.getBean() == null) {
            this.createInstance();
        }
        if ((nestedIndex = propertyName.indexOf(46)) == -1) {
            BeanFieldHandler beanFieldHandler = this.context.getBeanFieldHandler(propertyName);
            Class<?> paramType = beanFieldHandler.getType();
            try {
                if (paramType == String.class) {
                    beanFieldHandler.setValue(this, value);
                }
                if (value.isEmpty()) {
                    beanFieldHandler.setValue(this, null);
                }
                if (paramType.isEnum()) {
                    beanFieldHandler.setValue(this, Enum.valueOf(paramType, value));
                }
                Constructor<?> constructor = paramType.getConstructor(String.class);
                Object convertedValue = constructor.newInstance(value);
                beanFieldHandler.setValue(this, convertedValue);
            }
            catch (IllegalArgumentException e) {
                throw new ReflectionException(e);
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException(e);
            }
            catch (InvocationTargetException e) {
                throw new ReflectionException(e);
            }
            catch (SecurityException e) {
                throw new ReflectionException(e);
            }
            catch (NoSuchMethodException e) {
                throw new ReflectionException(this.context.getBeanClass().getName() + "." + propertyName + ": Cannot convert from String to " + paramType.getSimpleName() + ". Trying to convert " + value);
            }
            catch (InstantiationException e) {
                throw new ReflectionException(e);
            }
        } else {
            String thisProperty = propertyName.substring(0, nestedIndex);
            String nestedProperty = propertyName.substring(nestedIndex + 1);
            JuffrouBeanWrapper nestedWrapper = this.getLocalNestedWrapper(thisProperty);
            nestedWrapper.setValueOfString(nestedProperty, value);
        }
    }

    public void setValue(String propertyName, Object value) {
        int nestedIndex;
        if (this.getBean() == null) {
            if (value == null) {
                return;
            }
            this.createInstance();
        }
        if ((nestedIndex = propertyName.indexOf(46)) == -1) {
            this.context.getBeanFieldHandler(propertyName).setValue(this, value);
        } else {
            String thisProperty = propertyName.substring(0, nestedIndex);
            String nestedProperty = propertyName.substring(nestedIndex + 1);
            JuffrouBeanWrapper nestedWrapper = this.getLocalNestedWrapper(thisProperty);
            nestedWrapper.setValue(nestedProperty, value);
        }
    }

    public JuffrouBeanWrapper getNestedWrapper(String propertyName) {
        int nestedIndex = propertyName.indexOf(46);
        if (nestedIndex == -1) {
            return this.getLocalNestedWrapper(propertyName);
        }
        String thisProperty = propertyName.substring(0, nestedIndex);
        String nestedProperty = propertyName.substring(nestedIndex + 1);
        JuffrouBeanWrapper localNestedWrapper = this.getLocalNestedWrapper(thisProperty);
        return localNestedWrapper.getNestedWrapper(nestedProperty);
    }

    public JuffrouBeanWrapper getLocalNestedWrapper(String thisProperty) {
        JuffrouBeanWrapper nestedWrapper = this.nestedWrappers.get(thisProperty);
        if (nestedWrapper == null) {
            Object value = this.getValue(thisProperty);
            BeanWrapperContext bwc = this.context.getNestedContext(thisProperty, value);
            nestedWrapper = new JuffrouBeanWrapper(bwc, this, thisProperty);
            this.nestedWrappers.put(thisProperty, nestedWrapper);
        }
        return nestedWrapper;
    }

    protected JuffrouBeanWrapper getParentBeanWrapper() {
        return this.parentBeanWrapper;
    }

    protected String getParentBeanProperty() {
        return this.parentBeanProperty;
    }

    private void createInstance() {
        Object instance = this.context.newBeanInstance();
        if (this.isRoot()) {
            this.wrappedInstance = instance;
        } else {
            this.parentBeanWrapper.setValue(this.parentBeanProperty, instance);
        }
    }
}

