/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juffrou.reflect;

import java.util.HashMap;
import java.util.Map;
import net.sf.juffrou.reflect.JuffrouBeanWrapper;

public class BeanConverter<T1, T2> {
    private Map<String, String> b1b2BindingMap;
    private Map<String, String> b2b1BindingMap;
    private JuffrouBeanWrapper bw1;
    private JuffrouBeanWrapper bw2;

    public BeanConverter(Class<T1> clazz1, Class<T2> clazz2, Map<String, String> propertyBindingMap) {
        this.bw1 = new JuffrouBeanWrapper(clazz1);
        this.bw2 = new JuffrouBeanWrapper(clazz2);
        this.b1b2BindingMap = propertyBindingMap;
        this.b2b1BindingMap = new HashMap<String, String>();
        for (String b1prop : this.b1b2BindingMap.keySet()) {
            this.b2b1BindingMap.put(this.b1b2BindingMap.get(b1prop), b1prop);
        }
    }

    public T1 getBean1(T2 bean2) {
        this.bw1.setBean(null);
        this.bw2.setBean(bean2);
        for (String b2prop : this.b2b1BindingMap.keySet()) {
            this.bw1.setValue(this.b2b1BindingMap.get(b2prop), this.bw2.getValue(b2prop));
        }
        return (T1)this.bw1.getBean();
    }

    public T2 getBean2(T1 bean1) {
        this.bw2.setBean(null);
        this.bw1.setBean(bean1);
        for (String b1prop : this.b1b2BindingMap.keySet()) {
            this.bw2.setValue(this.b1b2BindingMap.get(b1prop), this.bw1.getValue(b1prop));
        }
        return (T2)this.bw2.getBean();
    }
}

