/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juffrou.reflect;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.sf.juffrou.reflect.BeanContextBuilder;
import net.sf.juffrou.reflect.BeanInstanceBuilder;
import net.sf.juffrou.reflect.BeanWrapperContext;
import net.sf.juffrou.reflect.BeanWrapperFactory;
import net.sf.juffrou.reflect.JuffrouBeanWrapper;
import net.sf.juffrou.reflect.internal.DefaultBeanInstanceCreator;

public class CustomizableBeanWrapperFactory
implements BeanWrapperFactory {
    private final Map<Type, BeanWrapperContext> classContextMap = new HashMap<Type, BeanWrapperContext>();
    private BeanInstanceBuilder beanInstanceCreator = null;
    private BeanContextBuilder beanContextCreator = null;

    @Override
    public BeanWrapperContext getBeanWrapperContext(Class clazz) {
        return this.getBeanWrapperContext(clazz, null);
    }

    @Override
    public BeanWrapperContext getBeanWrapperContext(Class clazz, Type ... types) {
        BeanWrapperContext context = this.classContextMap.get(clazz);
        if (context == null) {
            context = this.getBeanContextBuilder().build(this, clazz, types);
            this.classContextMap.put(clazz, context);
        }
        return context;
    }

    @Override
    public JuffrouBeanWrapper getBeanWrapper(Class clazz) {
        return new JuffrouBeanWrapper(this.getBeanWrapperContext(clazz, null));
    }

    @Override
    public JuffrouBeanWrapper getBeanWrapper(Object instance) {
        return new JuffrouBeanWrapper(this.getBeanWrapperContext(instance.getClass(), null), instance);
    }

    @Override
    public BeanInstanceBuilder getBeanInstanceBuilder() {
        if (this.beanInstanceCreator == null) {
            this.beanInstanceCreator = new DefaultBeanInstanceCreator();
        }
        return this.beanInstanceCreator;
    }

    public void setBeanInstanceBuilder(BeanInstanceBuilder beanInstanceBuilder) {
        this.beanInstanceCreator = beanInstanceBuilder;
    }

    private BeanContextBuilder getBeanContextBuilder() {
        if (this.beanContextCreator == null) {
            this.beanContextCreator = new DefaultBeanContextCreator();
        }
        return this.beanContextCreator;
    }

    public void setBeanContextBuilder(BeanContextBuilder beanContextBuilder) {
        this.beanContextCreator = beanContextBuilder;
    }

    private static class DefaultBeanContextCreator
    implements BeanContextBuilder {
        private DefaultBeanContextCreator() {
        }

        @Override
        public BeanWrapperContext build(CustomizableBeanWrapperFactory factory, Class clazz, Type ... types) {
            return new BeanWrapperContext(factory, clazz, types);
        }
    }
}

