/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juffrou.reflect.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import net.sf.juffrou.reflect.BeanWrapperContext;
import net.sf.juffrou.reflect.JuffrouBeanWrapper;
import net.sf.juffrou.reflect.error.ReflectionException;

public class BeanFieldHandler {
    private final BeanWrapperContext context;
    private final Field field;
    private final Class<?> ftype;
    private final Type genericType;
    private final Type[] ftypeArguments;
    private Method getter = null;
    private Method setter = null;

    public BeanFieldHandler(BeanWrapperContext context, Field field) {
        this.context = context;
        this.field = field;
        Object t = field.getGenericType();
        if (t instanceof TypeVariable && (t = context.getTypeArgumentsMap().get(t)) == null) {
            t = Object.class;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            this.ftypeArguments = pt.getActualTypeArguments();
        } else {
            this.ftypeArguments = null;
        }
        this.ftype = field.getType();
        this.genericType = t;
    }

    public BeanFieldHandler(BeanWrapperContext context, Method getterMethod) {
        this.context = context;
        this.field = null;
        this.getter = getterMethod;
        Object t = getterMethod.getGenericReturnType();
        if (t instanceof TypeVariable && (t = context.getTypeArgumentsMap().get(t)) == null) {
            t = Object.class;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            this.ftypeArguments = pt.getActualTypeArguments();
        } else {
            this.ftypeArguments = null;
        }
        this.ftype = getterMethod.getReturnType();
        this.genericType = t;
    }

    public Field getField() {
        return this.field;
    }

    public Class<?> getType() {
        return this.ftype;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public Type[] getTypeArguments() {
        return this.ftypeArguments;
    }

    public Object getValue(JuffrouBeanWrapper bw) {
        if (this.getter == null) {
            this.getter = BeanFieldHandler.inspectReadMethod(bw.getBeanClass(), this.field.getName(), this.ftype);
        }
        try {
            return this.getter.invoke(bw.getBean(), null);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    public void setValue(JuffrouBeanWrapper bw, Object value) {
        if (this.setter == null) {
            this.setter = BeanFieldHandler.inspectWriteMethod(bw.getBeanClass(), this.field.getName(), this.ftype);
        }
        try {
            this.setter.invoke(bw.getBean(), value);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    public void setValueIfBeanField(JuffrouBeanWrapper bw, Object value) {
        if (this.getter != null || this.setter != null) {
            try {
                this.setValue(bw, value);
            }
            catch (ReflectionException reflectionException) {
                // empty catch block
            }
        }
    }

    public static Method inspectReadMethod(Class<?> beanClass, String fieldName, Class<?> fieldClass) {
        String name = fieldName;
        String methodName = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
        try {
            Method getterMethod = beanClass.getMethod(methodName, null);
            return getterMethod;
        }
        catch (NoSuchMethodException e) {
            if (fieldClass == Boolean.TYPE || fieldClass == null) {
                if (name.startsWith("is")) {
                    name = name.substring(2);
                }
                methodName = "is" + name.substring(0, 1).toUpperCase() + name.substring(1);
                try {
                    Method getterMethod = beanClass.getMethod(methodName, null);
                    return getterMethod;
                }
                catch (NoSuchMethodException e1) {
                    throw new ReflectionException("The class " + beanClass.getSimpleName() + " does not have a getter method for the field " + fieldName);
                }
            }
            throw new ReflectionException("The class " + beanClass.getSimpleName() + " does not have a getter method for the field " + fieldName);
        }
    }

    public static Method inspectWriteMethod(Class<?> beanClass, String fieldName, Class<?> fieldClass) {
        String name = fieldName;
        String methodName = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        try {
            Method setterMethod = beanClass.getMethod(methodName, fieldClass);
            return setterMethod;
        }
        catch (NoSuchMethodException e) {
            if (fieldClass == Boolean.TYPE) {
                if (name.startsWith("is")) {
                    name = name.substring(2);
                }
                methodName = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
                try {
                    Method setterMethod = beanClass.getMethod(methodName, fieldClass);
                    return setterMethod;
                }
                catch (NoSuchMethodException e1) {
                    throw new ReflectionException("The class " + beanClass.getSimpleName() + " does not have a setter method for the field " + fieldName);
                }
            }
            throw new ReflectionException("The class " + beanClass.getSimpleName() + " does not have a setter method for the field " + fieldName);
        }
    }

    public Method getReadMethod(Class<?> beanClass) {
        if (this.getter == null) {
            this.getter = BeanFieldHandler.inspectReadMethod(beanClass, this.field.getName(), this.ftype);
        }
        return this.getter;
    }

    public Method getWriteMethod(Class<?> beanClass) {
        if (this.setter == null) {
            this.setter = BeanFieldHandler.inspectWriteMethod(beanClass, this.field.getName(), this.ftype);
        }
        return this.setter;
    }
}

