/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juffrou.reflect.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import net.sf.juffrou.reflect.BeanWrapperContext;
import net.sf.juffrou.reflect.JuffrouBeanWrapper;
import net.sf.juffrou.reflect.error.ReflectionException;

public class BeanFieldHandler {
    private final BeanWrapperContext context;
    private final Field field;
    private final Type ftype;
    private final Type[] ftypeArguments;
    private Method getter = null;
    private Method setter = null;

    public BeanFieldHandler(BeanWrapperContext context, Field field) {
        this.context = context;
        this.field = field;
        Object t = field.getGenericType();
        if (t instanceof TypeVariable && (t = context.getTypeArgumentsMap().get(t)) == null) {
            t = Object.class;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            this.ftypeArguments = pt.getActualTypeArguments();
        } else {
            this.ftypeArguments = null;
        }
        this.ftype = t;
    }

    public Field getField() {
        return this.field;
    }

    public Type getType() {
        return this.ftype;
    }

    public Type[] getTypeArguments() {
        return this.ftypeArguments;
    }

    public Object getValue(JuffrouBeanWrapper bw) {
        if (this.getter == null) {
            this.inspectReadMethod(bw.getBeanClass());
        }
        try {
            return this.getter.invoke(bw.getBean(), null);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    public void setValue(JuffrouBeanWrapper bw, Object value) {
        if (this.setter == null) {
            this.inspectWriteMethod(bw.getBeanClass());
        }
        try {
            this.setter.invoke(bw.getBean(), value);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    public void setValueIfBeanField(JuffrouBeanWrapper bw, Object value) {
        if (this.getter != null || this.setter != null) {
            try {
                this.setValue(bw, value);
            }
            catch (ReflectionException reflectionException) {
                // empty catch block
            }
        }
    }

    private void inspectReadMethod(Class<?> beanClass) {
        String name = this.field.getName();
        String methodName = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
        try {
            this.getter = beanClass.getMethod(methodName, null);
        }
        catch (NoSuchMethodException e) {
            if (this.field.getType() == Boolean.TYPE) {
                if (name.startsWith("is")) {
                    name = name.substring(2);
                }
                methodName = "is" + name.substring(0, 1).toUpperCase() + name.substring(1);
                try {
                    this.getter = beanClass.getMethod(methodName, null);
                }
                catch (NoSuchMethodException e1) {
                    throw new ReflectionException("The class " + beanClass.getSimpleName() + " does not have a getter method for the field " + this.field.getName());
                }
            }
            throw new ReflectionException("The class " + beanClass.getSimpleName() + " does not have a getter method for the field " + this.field.getName());
        }
    }

    private void inspectWriteMethod(Class<?> beanClass) {
        String name = this.field.getName();
        String methodName = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        try {
            this.setter = beanClass.getMethod(methodName, this.field.getType());
        }
        catch (NoSuchMethodException e) {
            if (this.field.getType() == Boolean.TYPE) {
                if (name.startsWith("is")) {
                    name = name.substring(2);
                }
                methodName = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
                try {
                    this.setter = beanClass.getMethod(methodName, this.field.getType());
                }
                catch (NoSuchMethodException e1) {
                    throw new ReflectionException("The class " + beanClass.getSimpleName() + " does not have a setter method for the field " + this.field.getName());
                }
            }
            throw new ReflectionException("The class " + beanClass.getSimpleName() + " does not have a setter method for the field " + this.field.getName());
        }
    }

    public Method getReadMethod(Class<?> beanClass) {
        if (this.getter == null) {
            this.inspectReadMethod(beanClass);
        }
        return this.getter;
    }

    public Method getWriteMethod(Class<?> beanClass) {
        if (this.setter == null) {
            this.inspectWriteMethod(beanClass);
        }
        return this.setter;
    }
}

