/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juffrou.util.reflect;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.sf.juffrou.error.BeanInstanceBuilderException;
import net.sf.juffrou.util.reflect.BeanContextBuilder;
import net.sf.juffrou.util.reflect.BeanInstanceBuilder;
import net.sf.juffrou.util.reflect.BeanWrapper;
import net.sf.juffrou.util.reflect.BeanWrapperContext;

public class BeanWrapperFactory {
    private final Map<Type, BeanWrapperContext> classContextMap = new HashMap<Type, BeanWrapperContext>();
    private BeanInstanceBuilder beanInstanceCreator = null;
    private BeanContextBuilder beanContextCreator = null;

    public BeanWrapperContext getBeanWrapperContext(Class clazz) {
        return this.getBeanWrapperContext(clazz, null);
    }

    public BeanWrapperContext getBeanWrapperContext(Class clazz, Type ... types) {
        BeanWrapperContext context = this.classContextMap.get(clazz);
        if (context == null) {
            context = this.getBeanContextBuilder().build(this, clazz, types);
            this.classContextMap.put(clazz, context);
        }
        return context;
    }

    public BeanWrapper getBeanWrapper(Class clazz) {
        return new BeanWrapper(this.getBeanWrapperContext(clazz), null);
    }

    public BeanWrapper getBeanWrapper(Object instance) {
        return new BeanWrapper(this.getBeanWrapperContext(instance.getClass(), null), instance);
    }

    protected BeanInstanceBuilder getBeanInstanceBuilder() {
        if (this.beanInstanceCreator == null) {
            this.beanInstanceCreator = new DefaultBeanInstanceCreator();
        }
        return this.beanInstanceCreator;
    }

    public void setBeanInstanceBuilder(BeanInstanceBuilder beanInstanceBuilder) {
        this.beanInstanceCreator = beanInstanceBuilder;
    }

    private BeanContextBuilder getBeanContextBuilder() {
        if (this.beanContextCreator == null) {
            this.beanContextCreator = new DefaultBeanContextCreator();
        }
        return this.beanContextCreator;
    }

    public void setBeanContextBuilder(BeanContextBuilder beanContextBuilder) {
        this.beanContextCreator = beanContextBuilder;
    }

    private static class DefaultBeanContextCreator
    implements BeanContextBuilder {
        private DefaultBeanContextCreator() {
        }

        @Override
        public BeanWrapperContext build(BeanWrapperFactory factory, Class clazz, Type ... types) {
            return new BeanWrapperContext(factory, clazz, types);
        }
    }

    private static class DefaultBeanInstanceCreator
    implements BeanInstanceBuilder {
        private DefaultBeanInstanceCreator() {
        }

        @Override
        public Object build(Class clazz) throws BeanInstanceBuilderException {
            Object instance;
            try {
                instance = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new BeanInstanceBuilderException(e);
            }
            catch (IllegalAccessException e) {
                throw new BeanInstanceBuilderException(e);
            }
            return instance;
        }
    }
}

