/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juffrou.util.reflect;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.sf.juffrou.error.BeanInstanceCreatorException;
import net.sf.juffrou.util.reflect.BeanContextCreator;
import net.sf.juffrou.util.reflect.BeanInstanceCreator;
import net.sf.juffrou.util.reflect.BeanWrapperContext;

public class BeanWrapperContextHierarchy {
    private final Map<Type, BeanWrapperContext> classContextMap = new HashMap<Type, BeanWrapperContext>();
    private BeanInstanceCreator beanInstanceCreator = new DefaultBeanInstanceCreator();
    private BeanContextCreator<? extends BeanWrapperContext> beanContextCreator = new DefaultBeanContextCreator();

    public void addTypeContext(Type type, BeanWrapperContext context) {
        this.classContextMap.put(type, context);
    }

    public BeanWrapperContext getTypeContext(Type type) {
        return this.classContextMap.get(type);
    }

    public BeanInstanceCreator getBeanInstanceCreator() {
        return this.beanInstanceCreator;
    }

    public void setBeanInstanceCreator(BeanInstanceCreator beanInstanceCreator) {
        this.beanInstanceCreator = beanInstanceCreator;
    }

    public BeanContextCreator<? extends BeanWrapperContext> getBeanContextCreator() {
        return this.beanContextCreator;
    }

    public void setBeanContextCreator(BeanContextCreator<? extends BeanWrapperContext> beanContextCreator) {
        this.beanContextCreator = beanContextCreator;
    }

    private static class DefaultBeanContextCreator
    implements BeanContextCreator<BeanWrapperContext> {
        private DefaultBeanContextCreator() {
        }

        @Override
        public BeanWrapperContext newBeanWrapperContext(BeanWrapperContextHierarchy hierarchyContext, Class clazz) {
            return new BeanWrapperContext(hierarchyContext, clazz);
        }

        @Override
        public BeanWrapperContext newBeanWrapperContext(BeanWrapperContextHierarchy hierarchyContext, Class clazz, Type ... types) {
            return new BeanWrapperContext(hierarchyContext, clazz, types);
        }
    }

    private static class DefaultBeanInstanceCreator
    implements BeanInstanceCreator {
        private DefaultBeanInstanceCreator() {
        }

        @Override
        public Object newBeanInstance(Class clazz) throws BeanInstanceCreatorException {
            Object instance;
            try {
                instance = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new BeanInstanceCreatorException(e);
            }
            catch (IllegalAccessException e) {
                throw new BeanInstanceCreatorException(e);
            }
            return instance;
        }
    }
}

