/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juffrou.util.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.juffrou.error.BeanInstanceCreatorException;
import net.sf.juffrou.error.ReflectionException;
import net.sf.juffrou.util.reflect.BeanContextCreator;
import net.sf.juffrou.util.reflect.BeanInstanceCreator;
import net.sf.juffrou.util.reflect.ReflectionUtil;
import net.sf.juffrou.util.reflect.internal.BeanFieldHandler;

public class BeanWrapperContext {
    private final Class clazz;
    private final Map<TypeVariable<?>, Type> typeArgumentsMap = new HashMap();
    private final Map<String, BeanFieldHandler> fields;
    private final Map<String, BeanWrapperContext> nestedContexts;
    private BeanInstanceCreator beanInstanceCreator;
    private BeanContextCreator<? extends BeanWrapperContext> beanContextCreator;
    private boolean eagerInstatiation;

    public BeanWrapperContext(Class clazz) {
        this(clazz, null);
    }

    public BeanWrapperContext(Class clazz, Type ... types) {
        if (types != null) {
            TypeVariable<Class<T>>[] typeParameters = clazz.getTypeParameters();
            for (int i = 0; i < types.length; ++i) {
                this.typeArgumentsMap.put(typeParameters[i], types[i]);
            }
        }
        this.clazz = clazz;
        this.typeArgumentsMap.putAll(ReflectionUtil.getTypeArgumentsMap(Class.class, clazz));
        if (!this.typeArgumentsMap.keySet().containsAll(Arrays.asList(clazz.getTypeParameters()))) {
            if (types == null) {
                throw new ReflectionException(clazz.getSimpleName() + " is a parameterized type. Please use the BeanWrapperContext(Class clazz, Type...types) constructor.");
            }
            throw new ReflectionException(clazz.getSimpleName() + " has more parameterized types than those specified.");
        }
        this.fields = new LinkedHashMap<String, BeanFieldHandler>();
        this.initFieldInfo(this.clazz, this.fields);
        this.nestedContexts = new HashMap<String, BeanWrapperContext>();
        this.beanInstanceCreator = new DefaultBeanInstanceCreator();
        this.beanContextCreator = new DefaultBeanContextCreator();
        this.eagerInstatiation = false;
    }

    private void initFieldInfo(Class<?> clazz, Map<String, BeanFieldHandler> fs) {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != Object.class) {
            this.initFieldInfo(superclass, fs);
        }
        for (Field f : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            fs.put(f.getName(), new BeanFieldHandler(this, f));
        }
    }

    public BeanWrapperContext getNestedContext(String thisProperty) {
        BeanWrapperContext nestedContext = this.nestedContexts.get(thisProperty);
        if (nestedContext == null) {
            Type propertyType = this.getBeanFieldHandler(thisProperty).getType();
            nestedContext = propertyType instanceof ParameterizedType ? this.beanContextCreator.newBeanWrapperContext((Class)((ParameterizedType)propertyType).getRawType(), ((ParameterizedType)propertyType).getActualTypeArguments()) : this.beanContextCreator.newBeanWrapperContext((Class)propertyType);
            this.nestedContexts.put(thisProperty, nestedContext);
        }
        return nestedContext;
    }

    public BeanFieldHandler getBeanFieldHandler(String propertyName) {
        BeanFieldHandler bfh = this.fields.get(propertyName);
        if (bfh == null) {
            throw new ReflectionException("The class " + this.clazz.getName() + " does not have a field with name " + propertyName);
        }
        return bfh;
    }

    public Type getType(String propertyName) {
        int nestedIndex = propertyName.indexOf(46);
        if (nestedIndex == -1) {
            return this.getBeanFieldHandler(propertyName).getType();
        }
        String thisProperty = propertyName.substring(0, nestedIndex);
        String nestedProperty = propertyName.substring(nestedIndex + 1);
        BeanWrapperContext nestedContext = this.getNestedContext(thisProperty);
        return nestedContext.getType(nestedProperty);
    }

    public Class<?> getBeanClass() {
        return this.clazz;
    }

    public Object newBeanInstance() {
        try {
            return this.beanInstanceCreator.newBeanInstance();
        }
        catch (BeanInstanceCreatorException e) {
            throw new ReflectionException(e);
        }
    }

    public Map<String, BeanFieldHandler> getFields() {
        return this.fields;
    }

    public Map<TypeVariable<?>, Type> getTypeArgumentsMap() {
        return this.typeArgumentsMap;
    }

    public void setBeanInstanceCreator(BeanInstanceCreator beanInstanceCreator) {
        this.beanInstanceCreator = beanInstanceCreator;
    }

    public BeanContextCreator<? extends BeanWrapperContext> getBeanContextCreator() {
        return this.beanContextCreator;
    }

    public void setBeanContextCreator(BeanContextCreator<? extends BeanWrapperContext> beanContextCreator) {
        this.beanContextCreator = beanContextCreator;
    }

    public boolean isEagerInstatiation() {
        return this.eagerInstatiation;
    }

    public void setEagerInstatiation(boolean eager) {
        this.eagerInstatiation = eager;
    }

    private class DefaultBeanContextCreator
    implements BeanContextCreator<BeanWrapperContext> {
        private DefaultBeanContextCreator() {
        }

        @Override
        public BeanWrapperContext newBeanWrapperContext(Class clazz) {
            return new BeanWrapperContext(clazz);
        }

        @Override
        public BeanWrapperContext newBeanWrapperContext(Class clazz, Type ... types) {
            return new BeanWrapperContext(clazz, types);
        }
    }

    private class DefaultBeanInstanceCreator
    implements BeanInstanceCreator {
        private DefaultBeanInstanceCreator() {
        }

        @Override
        public Object newBeanInstance() throws BeanInstanceCreatorException {
            Object instance;
            try {
                instance = BeanWrapperContext.this.clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new BeanInstanceCreatorException(e);
            }
            catch (IllegalAccessException e) {
                throw new BeanInstanceCreatorException(e);
            }
            return instance;
        }
    }
}

