/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsptest.assertion;

import net.sf.jsptest.assertion.DOMAssertion;
import org.w3c.dom.Element;

public class LinkAssertion
extends DOMAssertion {
    public LinkAssertion(Element context) {
        this.context = context;
    }

    public void withText(String labelText) {
        this.shouldContainElement("Link with text '" + labelText + "' was not found from " + this.getContextAsString(), "//A[text()='" + labelText + "']");
    }

    public void withPartialText(String substringOfLabelText) {
        this.shouldContainElement("Link with partial text '" + substringOfLabelText + "' was not found from " + this.getContextAsString(), "//A[fn:contains(text(), '" + substringOfLabelText + "')]");
    }

    public void withName(String name) {
        this.shouldContainElement("Link with name '" + name + "' was not found from " + this.getContextAsString(), "//A[@NAME='" + name + "']");
    }

    public void withId(String id) {
        this.shouldContainElement("Link with ID '" + id + "' was not found from " + this.getContextAsString(), "//A[@ID='" + id + "']");
    }

    public void withHref(String url) {
        this.shouldContainElement("Link pointing to " + url + " was not found from " + this.getContextAsString(), "//A[@HREF='" + url + "']");
    }

    public void withClass(String cssClass) {
        this.shouldContainElement("Link with CSS class '" + cssClass + "' was not found from " + this.getContextAsString(), "//A[@CLASS='" + cssClass + "']");
    }

    public void withImageId(String id) {
        this.shouldContainElement("Image link with image ID '" + id + "' was not found from " + this.getContextAsString(), "//A/IMG[@ID='" + id + "']");
    }

    public void withImageTitle(String title) {
        this.shouldContainElement("Image link with image titled '" + title + "' was not found from " + this.getContextAsString(), "//A/IMG[@TITLE='" + title + "']");
    }

    public void withImageName(String name) {
        this.shouldContainElement("Image link with image named '" + name + "' was not found from " + this.getContextAsString(), "//A/IMG[@NAME='" + name + "']");
    }

    public void withImageSrc(String url) {
        this.shouldContainElement("Image link with image URL '" + url + "' was not found from " + this.getContextAsString(), "//A/IMG[@SRC='" + url + "']");
    }

    public void withImageFileName(String filename) {
        this.shouldContainElement("Image link with the image URL ending with '" + filename + "' was not found from " + this.getContextAsString(), "//A/IMG[fn:ends-with(@SRC, '" + filename + "')]");
    }
}

