/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsptest.assertion;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import net.sf.jsptest.html.Form;
import net.sf.jsptest.html.FormField;

public class FormFieldAssertion {
    private final List fields;
    private final String fieldName;

    public FormFieldAssertion(List forms, String fieldName) {
        this.fieldName = fieldName;
        this.fields = new ArrayList();
        Iterator i = forms.iterator();
        while (i.hasNext()) {
            Form form = (Form)i.next();
            if (!form.hasInputField(fieldName)) continue;
            this.fields.add(form.getInputField(fieldName));
        }
    }

    public void shouldHaveValue(String expectedValue) {
        ArrayList<String> actuals = new ArrayList<String>();
        Iterator i = this.fields.iterator();
        while (i.hasNext()) {
            FormField form = (FormField)i.next();
            if (expectedValue.equals(form.getValue())) {
                return;
            }
            actuals.add(form.getValue());
        }
        Assert.fail((String)("Field '" + this.fieldName + "' does not have value '" + expectedValue + "': " + actuals));
    }
}

