/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsptest.assertion;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import net.sf.jsptest.assertion.ElementChooser;
import net.sf.jsptest.assertion.FormFieldAssertion;
import net.sf.jsptest.html.Form;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FormAssertion {
    private final List forms = new ArrayList();

    public FormAssertion(Document document, ElementChooser chooser) {
        NodeList elements = document.getElementsByTagName("FORM");
        for (int i = 0; i < elements.getLength(); ++i) {
            Element element = (Element)elements.item(i);
            if (!chooser.accept(element)) continue;
            this.forms.add(new Form(element));
        }
        if (this.forms.isEmpty()) {
            Assert.fail((String)"Form not found.");
        }
    }

    public void shouldHaveField(String name) {
        Iterator i = this.forms.iterator();
        while (i.hasNext()) {
            Form form = (Form)i.next();
            if (!form.hasInputField(name)) continue;
            return;
        }
        Assert.fail((String)("No form field '" + name + "' on page"));
    }

    public void shouldHaveSubmitButton(String nameOrLabel) {
        Iterator i = this.forms.iterator();
        while (i.hasNext()) {
            Form form = (Form)i.next();
            if (!form.hasSubmitButton(nameOrLabel)) continue;
            return;
        }
        Assert.fail((String)("No form submit button '" + nameOrLabel + "' on page"));
    }

    public void shouldHaveSubmitButton() {
        Iterator i = this.forms.iterator();
        while (i.hasNext()) {
            Form form = (Form)i.next();
            if (!form.hasSubmitButton()) continue;
            return;
        }
        Assert.fail((String)"No form submit button on page");
    }

    public FormFieldAssertion field(String fieldName) {
        this.shouldHaveField(fieldName);
        return new FormFieldAssertion(this.forms, fieldName);
    }
}

