/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsptest.assertion;

import junit.framework.AssertionFailedError;
import net.sf.jsptest.HtmlTestCase;
import net.sf.jsptest.assertion.ElementAssertion;
import net.sf.jsptest.assertion.OutputAssertion;
import net.sf.jsptest.assertion.PageAssertion;

public abstract class ExpectedAssertionFailure {
    private HtmlTestCase testcase;

    protected abstract void run() throws Exception;

    public ExpectedAssertionFailure(HtmlTestCase testcase) throws Exception {
        this(testcase, "Operation should've failed but it didn't.");
    }

    public ExpectedAssertionFailure(HtmlTestCase testcase, String message) throws Exception {
        this.testcase = testcase;
        this.verify(message);
    }

    protected PageAssertion page() {
        return this.testcase.page();
    }

    protected OutputAssertion output() {
        return this.testcase.output();
    }

    protected ElementAssertion element(String xpath) {
        return this.testcase.element(xpath);
    }

    private void verify(String message) {
        try {
            this.run();
            throw new NoExceptionWasThrown();
        }
        catch (AssertionFailedError expected) {
        }
        catch (NoExceptionWasThrown e) {
            throw new AssertionFailedError(message);
        }
        catch (Throwable e) {
            throw new IncorrectExceptionError("A non-assertion exception was thrown: " + e.getClass().getName(), e);
        }
    }

    private static class NoExceptionWasThrown
    extends Exception {
        private NoExceptionWasThrown() {
        }
    }

    public static class IncorrectExceptionError
    extends RuntimeException {
        public IncorrectExceptionError(String message, Throwable e) {
            super(message, e);
        }
    }
}

