/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsptest;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import net.sf.jsptest.assertion.OutputAssertion;
import net.sf.jsptest.compiler.api.Jsp;
import net.sf.jsptest.compiler.api.JspCompiler;
import net.sf.jsptest.compiler.api.JspCompilerFactory;
import net.sf.jsptest.compiler.api.JspExecution;
import net.sf.jsptest.utils.IO;
import org.apache.log4j.Logger;

public abstract class JspTestCase
extends TestCase {
    private Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private Map requestAttributes;
    private Map sessionAttributes;
    private Map substituteTaglibs;
    private JspExecution execution;

    protected void setUp() throws Exception {
        this.requestAttributes = new HashMap();
        this.sessionAttributes = new HashMap();
        this.substituteTaglibs = new HashMap();
    }

    protected String getWebRoot() {
        return ".";
    }

    protected void setSessionAttribute(String attribute, String value) {
        this.sessionAttributes.put(attribute, value);
    }

    protected void setRequestAttribute(String attribute, String value) {
        this.requestAttributes.put(attribute, value);
    }

    protected void get(String path) throws Exception {
        this.request(path, "GET");
    }

    protected void post(String path) throws Exception {
        this.request(path, "POST");
    }

    protected void request(String path, String httpMethod) throws Exception {
        this.validatePath(path);
        JspCompiler compiler = JspCompilerFactory.newInstance();
        this.log.debug((Object)("Using compiler " + compiler.getClass().getName() + " and webroot " + new File(this.getWebRoot()).getAbsolutePath()));
        compiler.setWebRoot(this.getWebRoot());
        compiler.setOutputDirectory(this.getOutputDirectory());
        Jsp jsp = compiler.compile(path, this.substituteTaglibs);
        this.log.debug((Object)("Simulating a request to " + path));
        this.execution = jsp.request(httpMethod, this.requestAttributes, this.sessionAttributes);
    }

    private void validatePath(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The JSP path must start with a \"/\"");
        }
    }

    private String getOutputDirectory() {
        return "target/jsptest";
    }

    protected File getRenderedResponse() {
        return this.execution.getRenderedResponse();
    }

    public OutputAssertion output() {
        try {
            return new OutputAssertion(IO.readToString((File)this.getRenderedResponse()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void substituteTaglib(String name, Class newImplementation) {
        this.substituteTaglibs.put(name, newImplementation);
    }
}

